// generated by: arc -uRNMLP -A ./argrt -o argilectx.c -H argilectx.h -m argilectx.argl argilectx.arg 
#line 29 "argilectx.arg"
#include "argile.h" //;
#include <libargile/parser.h> //;

#include "argilectx.h"

#line 360 "argilectx.arg"
static void attribute_comments_to_calls();
/** :attribute comments to calls: -> nothing **/
#line 731 "argilectx.arg"
static void print_line(char *, int);
/** :print line <text dst> <int len>: -> nothing **/
#line 1097 "argilectx.arg"
static int ends_by(char *, int, char *);
/** :<text str> ends by <int n> <text end>: -> int **/
#line 1175 "argilectx.arg"
static argile_file_t * try_new_file(char *);
/** :try new file <text path>: -> (argile) file **/
#line 1337 "argilectx.arg"
static char * convert_to_daltonism(char *);
/** :convert <text colour> to daltonism: -> text **/
#line 281 "argilectx.arg"
static unsigned char is_not_included(argile_code_t *);
/** :<argile code c> is not included: -> bool **/
#line 380 "argilectx.arg"
static unsigned char argile_pos_su_argile_pos(argile_pos_t *, argile_pos_t *);
/** :<pos a> > <pos b>: -> bool **/
#line 418 "argilectx.arg"
static void comment(comment_t *);
/** :<comment c>: -> nothing **/
#line 533 "argilectx.arg"
static void print_define(char * * name, int * size, argile_file_t * * file);
/** :print define: -> nothing **/
#line 504 "argilectx.arg"
static int get_word_size_of(char *);
/** :get word size of <text t>: -> int **/
#line 992 "argilectx.arg"
static void write_ref_or_raw_in_with(argile_buff_t *, argile_buff_t *, argile_def_t *, char *);
/** :write ref or raw <buff tb> in <buff out> with <def d> <text name>: -> nothing **/
#line 1147 "argilectx.arg"
static void add_include(char *);
/** :add include <text p>: -> nothing **/
#line 1212 "argilectx.arg"
static argile_file_t * try_in_dir(char *, int, char *, int);
/** :try <text path> <int plen> in dir <text dir> <int dlen>: -> (argile) file **/
#line 1258 "argilectx.arg"
static void strip_useless_slashes_in(char *);
/** :strip useless slashes in <text s>: -> nothing **/
#line 1277 "argilectx.arg"
static unsigned char doesn_t_end_by_ext(char *);
/** :<text str> doesn ' t end by ext: -> bool **/
#line 1272 "argilectx.arg"
static void reduce(char *, char *);
/** :reduce <text d> <text s>: -> nothing **/
#line 1720 "argilectx.arg"
static int id_end_num(char *, unsigned int, int *);
/** :id end num <text s> <nat n> <(int) & num>: -> int **/
#line 1762 "argilectx.arg"
static void check_id_num(argile_buff_t *, char *, unsigned char *, int *, int *);
/** :check id num <buff b> <text id> <(bool) & found> <(int) & min> <(int) & max>: -> nothing **/
#line 1773 "argilectx.arg"
static void check_call_id_num(argile_call_t *, argile_buff_t *, unsigned char *, int *, int *);
/** :check call id num <call> <buff b> <(bool) & found> <(int) & min> <(int) & max>: -> nothing **/
#line 1853 "argilectx.arg"
static void search_in_with(argile_list_t *, argile_code_t *, void (*)(argile_def_t *));
/** :search <list of (argile syntax) syn> in <argile code code> with <function (def) callback>: -> nothing **/
#line 1865 "argilectx.arg"
static void search_in_with_2(argile_list_t *, argile_call_t *, void (*)(argile_def_t *));
/** :search <list of (argile syntax) syn> in <call> with <function (def) callback>: -> nothing **/
#line 1937 "argilectx.arg"
static void split_op(char *, int, int);
/** :split op <text str> <int len> <int optoken>: -> nothing **/
#line 2013 "argilectx.arg"
static argile_list_t * new_range(unsigned int, unsigned int);
/** :new range <nat a> <nat b>: -> list of (array of (nat)) **/

#line 197 "argilectx.arg"
argile_t argile = ((argile_t){0});

#line 203 "argilectx.arg"
char * argile_get_version()
/** :argile_get_version: -> text **/
{
#line 205 "argilectx.arg"
  return "libargile"" (Argile compiler library) version "VERSION;
}

#line 214 "argilectx.arg"
int argile_init()
/** :argile_init: -> int **/
{
#line 215 "argilectx.arg"
  memset(&argile, 0, sizeof(*&argile));
  (argile).colpertab = 8;
  (argile).maxmatch = 500;
  (argile).maxgen = 500;
  (argile).maxreject = 5;
  (argile).next_type = ((int)ARGILE_NEXT_TYPE);
  ((argile).enc_utf8).charsize = (void *)&argile_utf8_charsize;
  ((argile).enc_utf8).charat = (void *)&argile_utf8_charat;
  (argile).output = (void *)&argile_output_file;
  (argile).output_data = stdout;
  (argile).output_name = "standard output";
  (argile).output_line = 1;
  (argile).last_input_line = 1;
  (argile).next_input_buff = argile_buff_new(512);
  (argile).get_comments = 1;
#line 231 "argilectx.arg"
  argile_add_keyword("auto");
  argile_add_keyword("break");
  argile_add_keyword("case");
  argile_add_keyword("char");
  argile_add_keyword("const");
  argile_add_keyword("continue");
  argile_add_keyword("default");
  argile_add_keyword("do");
  argile_add_keyword("double");
  argile_add_keyword("else");
  argile_add_keyword("enum");
  argile_add_keyword("extern");
  argile_add_keyword("float");
  argile_add_keyword("for");
  argile_add_keyword("goto");
  argile_add_keyword("if");
  argile_add_keyword("int");
  argile_add_keyword("long");
  argile_add_keyword("register");
  argile_add_keyword("return");
  argile_add_keyword("short");
  argile_add_keyword("signed");
  argile_add_keyword("sizeof");
  argile_add_keyword("static");
  argile_add_keyword("struct");
  argile_add_keyword("switch");
  argile_add_keyword("typedef");
  argile_add_keyword("union");
  argile_add_keyword("unsigned");
  argile_add_keyword("void");
  argile_add_keyword("volatile");
  argile_add_keyword("while");
  argile_add_keyword("anon_arg");
  argile_add_keyword("anon_va");
  return 0;
}

#line 271 "argilectx.arg"
void argile_uninit()
/** :argile_uninit: -> nothing **/
{
#line 275 "argilectx.arg"
  int i_2 = 0;

#line 272 "argilectx.arg"
  argile_choke_leaks();
  if (((argile).error != NULL)) {
    argile_dbg_free((argile).error);
  } //;
#line 276 "argilectx.arg"
  for (i_2 = 0; (i_2 < 512); (i_2)++) {
    argile_list_del(((argile).types)[i_2]);
  };
  if ((((argile).main != NULL) && is_not_included((argile).main))) {
    argile_code_del((argile).main);
  } //;
#line 285 "argilectx.arg"
  for (i_2 = 0; (i_2 < 1024); (i_2)++) {
    argile_list_del(((argile).ids)[i_2]);
  };
#line 287 "argilectx.arg"
  for (i_2 = 0; (i_2 < 4096); (i_2)++) {
    argile_list_del(((argile).defs)[i_2]);
  };
#line 289 "argilectx.arg"
  argile_list_del((argile).used);
  argile_list_del((argile).mods);
  argile_list_del((argile).file_path);
  argile_list_del((argile).som_path);
  argile_list_del((argile).globally);
  argile_list_del((argile).includes);
  argile_list_del((argile).sysincludes);
  argile_list_del((argile).op_ranges);
  argile_list_del((argile).options);
  argile_list_del((argile).keywords);
  argile_list_del((argile).warns);
  argile_list_del((argile).comments);
  argile_buff_del((argile).next_input_buff);
  memset(&argile, 0, sizeof(*&argile));
}

#line 311 "argilectx.arg"
char * argile_get_option(char * opt)
/** :argile_get_option <text opt>: -> text **/
{
#line 312 "argilectx.arg"
  argile_list_t * lo;

#line 312 "argilectx.arg"
  lo = (argile).options;
  while (!(((lo == NULL) || (((argile_list_t *)lo)->next == NULL)))) {
    if ((strcmp(*((char * *)&((argile_list_t *)lo)->data), opt) == 0)) {
#line 464 "./argrt/std.argl"
      return *((char * *)&((argile_list_t *)((argile_list_t *)lo)->next)->data);
    } //;
#line 315 "argilectx.arg"
    lo = ((argile_list_t *)lo)->next;
  };
#line 316 "argilectx.arg"
  return (char *)0;
}

#line 325 "argilectx.arg"
int argile_parse(void * data)
/** :argile_parse <any data>: -> int **/
{
#line 342 "argilectx.arg"
  int ret = 0;

#line 327 "argilectx.arg"
  (argile).input_data = data;
  (argile).input_ended = 0;
  (argile).separator = 0;
  (argile).new_line = 1;
  (argile).indents = ((argile_list_t *)0);
  (argile).tokens = ((argile_list_t *)0);
  (argile).last_token = ((argile_list_t *)0);
  (((argile).loc).start).row = 1;
  (((argile).loc).start).col = 0;
  (((argile).loc).end).row = 1;
  (((argile).loc).end).col = 0;
  (argile).linebuff = argile_buff_new(0);
  argile_resurrect();
#line 342 "argilectx.arg"
  ret = argile_yyparse();
#line 345 "argilectx.arg"
  ((((argile).loc).end).row)--;
  argile_buff_del((argile).linebuff);
#line 346 "argilectx.arg"
  (argile).linebuff = ((argile_buff_t *)0);
  argile_list_del((argile).indents);
#line 347 "argilectx.arg"
  (argile).indents = ((argile_list_t *)0);
  argile_list_del((argile).tokens);
#line 348 "argilectx.arg"
  (argile).tokens = ((argile_list_t *)0);
  (argile).last_token = ((argile_list_t *)0);
#line 351 "argilectx.arg"
  if (((argile).error)) {
    argile_choke_leaks();
    if ((((argile).main) && (((argile).main)->calls))) {
      ((argile).main)->calls = ((argile_list_t *)0);
    } //;
#line 355 "argilectx.arg"
    return -1;
  } //;
#line 356 "argilectx.arg"
  argile_forget_leaks();
  attribute_comments_to_calls();
  return ret;
}

#line 360 "argilectx.arg"
static void attribute_comments_to_calls()
/** :attribute comments to calls: -> nothing **/
{
  argile_list_t * lcall;
  argile_list_t * lcomm;

#line 361 "argilectx.arg"
  if (!((argile).get_comments)) {
#line 464 "./argrt/std.argl"
    return;
  } //;
#line 362 "argilectx.arg"
  if (((argile).main == NULL)) {
#line 464 "./argrt/std.argl"
    return;
  } //;
#line 363 "argilectx.arg"
  lcall = ((argile).main)->calls;
  lcomm = argile_list_start((argile).comments);
  while (!(((lcall == NULL) || (lcomm == NULL)))) {
    comment_t * comm = ((comment_t *)0);
    argile_pos_t * pcomm = ((argile_pos_t *)0);

#line 366 "argilectx.arg"
    comm = *((comment_t * *)&((argile_list_t *)lcomm)->data);
    pcomm = &(comm)->pos;
#line 370 "argilectx.arg"
    while (!(((lcall == NULL) || argile_pos_su_argile_pos(&((*((argile_call_t * *)&((argile_list_t *)lcall)->data))->loc).start, pcomm)))) {
#line 481 "./argrt/std.argl"
      lcall = ((argile_list_t *)lcall)->next;
    };
#line 371 "argilectx.arg"
    if (!((lcall == NULL))) {
      argile_call_t * call = ((argile_call_t *)0);

#line 372 "argilectx.arg"
      call = *((argile_call_t * *)&((argile_list_t *)lcall)->data);
      if (((call)->comment)) {
        argile_dbg_free((call)->comment);
      } //;
#line 375 "argilectx.arg"
      (call)->comment = (comm)->txt;
      (comm)->txt = (char *)0;
    } //;
    lcomm = ((argile_list_t *)lcomm)->next;
  };
}

#line 390 "argilectx.arg"
int argile_compile()
/** :argile_compile: -> int **/
{
#line 391 "argilectx.arg"
  int r = 0;

#line 391 "argilectx.arg"
  r = argile_compile_as((argile_type_t)ARGILE_TYPE_ANYTHING);
  argile_add_gstats();
  return r;
}

#line 401 "argilectx.arg"
int argile_compile_as(argile_type_t t)
/** :argile_compile_as <argile type t>: -> int **/
{
#line 402 "argilectx.arg"
  if (!(((argile).main))) {
#line 464 "./argrt/std.argl"
    return 0;
  } //;
#line 403 "argilectx.arg"
  return argile_code_compile((argile).main, t);
}

#line 410 "argilectx.arg"
void argile_add_comment(char * txt, int line, int col)
/** :argile_add_comment <text txt> <int line> <int col>: -> nothing **/
{
#line 414 "argilectx.arg"
  comment_t * cmt = ((comment_t *)0);

#line 411 "argilectx.arg"
  if ((*&(txt)[0] != *&(":")[0])) {
    argile_dbg_free(txt);
    return;
  } //;
#line 414 "argilectx.arg"
  cmt = ((comment_t *)memset(argile_dbg_malloc(sizeof(comment_t)), 0, sizeof(comment_t)));
  (cmt)->txt = txt;
  ((cmt)->pos).row = line;
  ((cmt)->pos).col = col;
  argile_list_append(&(argile).comments, argile_list_new(cmt, (void *)&comment));
}

#line 428 "argilectx.arg"
void argile_add_keyword(char * word)
/** :argile_add_keyword <text word>: -> nothing **/
{
#line 429 "argilectx.arg"
  unsigned int hash = 0;

#line 429 "argilectx.arg"
  hash = (argile_hash(word) % 1024);
  argile_list_prepend(&((argile).ids)[hash], argile_list_new(word, ((argile_deleter_t)0)));
  argile_list_prepend(&(argile).keywords, argile_list_new(word, ((argile_deleter_t)0)));
}

#line 440 "argilectx.arg"
void argile_gencode(char * header)
/** :argile_gencode <text header>: -> nothing **/
{
#line 441 "argilectx.arg"
  argile_list_t * lc;

#line 442 "argilectx.arg"
  if (((argile).globally != NULL)) {
#line 444 "argilectx.arg"
    for (lc = argile_list_end((argile).globally); (lc); lc = ((argile_list_t *)lc)->prev) {
      argile_code_t * code = ((argile_code_t *)0);

#line 445 "argilectx.arg"
      code = *((argile_code_t * *)&((argile_list_t *)lc)->data);
      if (!((code)->compiled)) {
        unsigned char old;

#line 447 "argilectx.arg"
        old = (argile).main_only;
        (argile).main_only = 0;
        argile_code_compile(code, (code)->type);
        (argile).main_only = old;
      } //;
#line 451 "argilectx.arg"
      argile_code_gencode(code);
    };
#line 452 "argilectx.arg"
    argile_puts("\n");
  } //;
  argile_code_pregen_ids((argile).main);
#line 456 "argilectx.arg"
  if ((header)) {
    argile_printf("#include \"%s\"\n\n", header);
  } //;
#line 458 "argilectx.arg"
  else {
    argile_gen_header((char *)0);
  };
#line 462 "argilectx.arg"
  argile_code_gen_typedefs((argile).main, 1);
#line 465 "argilectx.arg"
  argile_code_gen_enums((argile).main, 1);
#line 468 "argilectx.arg"
  argile_code_gen_structs_and_unions((argile).main, 1);
#line 471 "argilectx.arg"
  argile_code_gen_protos((argile).main, 1);
#line 474 "argilectx.arg"
  argile_code_gen_vars((argile).main, 0);
  for (lc = (argile).globally; (lc); lc = ((argile_list_t *)lc)->next) {
    argile_code_gen_vars(*((argile_code_t * *)&((argile_list_t *)lc)->data), 0);
  };
#line 479 "argilectx.arg"
  argile_code_gen_private_vars((argile).main);
#line 482 "argilectx.arg"
  argile_code_gen_funcs((argile).main);
#line 484 "argilectx.arg"
  if ((argile).do_main) {
#line 486 "argilectx.arg"
    argile_code_gen_main((argile).main);
  } //;
  argile_flush_refs();
}

#line 496 "argilectx.arg"
void argile_gen_header(char * name)
/** :argile_gen_header <text name>: -> nothing **/
{
#line 497 "argilectx.arg"
  int size = 0;
  argile_file_t * file = ((argile_file_t *)0);

#line 500 "argilectx.arg"
  if ((name)) {
    char * s = "";
#line 512 "argilectx.arg"
    int match = 0;
    argile_list_t * lf;

#line 501 "argilectx.arg"
    s = strrchr(name, '/');
    if ((s)) {
#line 464 "./argrt/std.argl"
      name = ((s) + 1);
    } //;
#line 503 "argilectx.arg"
    size = get_word_size_of(name);
#line 513 "argilectx.arg"
    lf = (argile).used;
    for (; (lf); lf = ((argile_list_t *)lf)->next) {
      argile_file_t * f = ((argile_file_t *)0);
#line 521 "argilectx.arg"
      int sz = 0;

#line 515 "argilectx.arg"
      f = *((argile_file_t * *)&((argile_list_t *)lf)->data);
      s = strrchr((f)->path, '/');
      if ((s)) {
        (s)++;
      } //;
#line 519 "argilectx.arg"
      else {
        s = (f)->path;
      };
#line 521 "argilectx.arg"
      sz = get_word_size_of(s);
      if (((sz == size) && (strncmp(s, name, sz) == 0))) {
        (match)++;
        file = f;
      } //;
    };
#line 525 "argilectx.arg"
    if ((match != 1)) {
#line 525 "argilectx.arg"
      file = ((argile_file_t *)0);
    } //;
    argile_puts("#ifndef ");
    print_define(&name, &size, &file);
    argile_puts("\n#define ");
    print_define(&name, &size, &file);
    argile_puts("\n\n");
  } //;
#line 542 "argilectx.arg"
  argile_code_gen_defines((argile).main);
#line 545 "argilectx.arg"
  argile_code_gen_typedefs((argile).main, 0);
#line 548 "argilectx.arg"
  argile_code_gen_includes((argile).main);
#line 551 "argilectx.arg"
  argile_code_gen_enums((argile).main, 0);
#line 554 "argilectx.arg"
  argile_code_gen_structs_and_unions((argile).main, 0);
#line 557 "argilectx.arg"
  if ((name)) {
    argile_code_gen_vars((argile).main, 2);
  } //;
#line 559 "argilectx.arg"
  else {
    argile_code_gen_vars((argile).main, 1);
  };
#line 563 "argilectx.arg"
  argile_code_gen_protos((argile).main, 0);
#line 565 "argilectx.arg"
  if ((name)) {
    argile_puts("#endif /* ");
    print_define(&name, &size, &file);
    argile_puts(" */\n");
  } //;
}

#line 576 "argilectx.arg"
void argile_gen_module(FILE * f)
/** :argile_gen_module <FILE f>: -> nothing **/
{
#line 577 "argilectx.arg"
  argile_buff_t s = ((argile_buff_t){0});
#line 577 "argilectx.arg"
  argile_buff_t t_2 = ((argile_buff_t){0});
  argile_call_t * c = ((argile_call_t *)0);
  char * new_line = "";
#line 581 "argilectx.arg"
  unsigned char old;
#line 583 "argilectx.arg"
  argile_module_t * mod = ((argile_module_t *)0);
#line 615 "argilectx.arg"
  argile_def_t * duse = ((argile_def_t *)0);
  argile_def_t * dinc = ((argile_def_t *)0);
  argile_def_t * dvar = ((argile_def_t *)0);
  argile_def_t * dfunc = ((argile_def_t *)0);
  argile_def_t * dext = ((argile_def_t *)0);
  argile_def_t * dnodecl = ((argile_def_t *)0);
  argile_def_t * dtref = ((argile_def_t *)0);
  argile_def_t * dtraw = ((argile_def_t *)0);

#line 579 "argilectx.arg"
  new_line = (((argile).dump_indent) ? ("\n") : (";\n"));
#line 581 "argilectx.arg"
  old = (argile).use_colors;
  (argile).use_colors = 0;
  mod = argile_getmod("std");
  if ((mod)) {
    argile_list_t * lx;

#line 585 "argilectx.arg"
    lx = ((argile).main)->calls;
    for (; (lx); lx = ((argile_list_t *)lx)->next) {
#line 588 "argilectx.arg"
      argile_def_t * d = ((argile_def_t *)0);

#line 587 "argilectx.arg"
      c = *((argile_call_t * *)&((argile_list_t *)lx)->data);
      d = (c)->def;
      if ((((d) && ((d)->dtype == ARGILE_DEF_BIND)) && (((d)->dval).bind)->modulable)) {
        argile_buff_flush(&s);
        argile_call_string(c, 0, &s);
        if (((s).ptr)) {
          if (((c)->comment)) {
            fprintf(f, "(:%s:)\n", (c)->comment);
          } //;
#line 595 "argilectx.arg"
          fwrite((s).ptr, (s).len, 1, f);
        } //;
#line 596 "argilectx.arg"
        fputs(new_line, f);
      } //;
    };
  } //;
#line 597 "argilectx.arg"
  else {
    argile_list_t * p = ((argile_list_t *)0);
    argile_list_t * lx;
#line 607 "argilectx.arg"
    argile_list_t * lp;

#line 599 "argilectx.arg"
    lx = (argile).used;
    for (; (lx); lx = ((argile_list_t *)lx)->next) {
      argile_file_t * fp = ((argile_file_t *)0);
      argile_code_t * u = ((argile_code_t *)0);

#line 601 "argilectx.arg"
      fp = *((argile_file_t * *)&((argile_list_t *)lx)->data);
#line 603 "argilectx.arg"
      for (u = ((argile).main)->upper; (u); u = (u)->upper) {
        if (((u)->ghost == (fp)->code)) {
          argile_list_prepend(&p, argile_list_new((fp)->path, ((argile_deleter_t)0)));
          break;
        } //;
      };
    };
#line 607 "argilectx.arg"
    lp = p;
    for (; (lp); lp = ((argile_list_t *)lp)->next) {
      fprintf(f, "use \"%s\"%s", *((char * *)&((argile_list_t *)lp)->data), new_line);
    };
#line 610 "argilectx.arg"
    argile_list_del(p);
  };
#line 611 "argilectx.arg"
  if ((((argile).main)->calls)) {
    c = *((argile_call_t * *)&((argile_list_t *)((argile).main)->calls)->data);
  } //;
#line 613 "argilectx.arg"
  else {
    c = ((argile_call_t *)0);
  };
#line 615 "argilectx.arg"
  duse = argile_find_def("std", "use", "", 1);
  dinc = argile_find_def("std", "use", "include", 1);
  dvar = argile_find_def("std", "extdef", "", 1);
  dfunc = argile_find_def("std", "extdef", "func", 1);
  dext = argile_find_def("std", "extern", "", 1);
  dnodecl = argile_find_def("std", "extern", "nodecl", 1);
  dtref = argile_find_def("std", "typeref", "", 1);
  dtraw = argile_find_def("std", "typeraw", "", 1);
  if (((((((((duse) && (dinc)) && (dvar)) && (dfunc)) && (dext)) && (dnodecl)) && (dtref)) && (dtraw))) {
#line 625 "argilectx.arg"
    argile_list_t * lx;

#line 625 "argilectx.arg"
    lx = ((argile).main)->defs;
    for (; (lx); lx = ((argile_list_t *)lx)->next) {
      argile_def_t * d = ((argile_def_t *)0);

#line 627 "argilectx.arg"
      d = *((argile_def_t * *)&((argile_list_t *)lx)->data);
      if (((d)->locall || (d)->private)) {
#line 464 "./argrt/std.argl"
        continue;
      } //;
#line 629 "argilectx.arg"
      if (((d)->dtype == ARGILE_DEF_VAR)) {
        argile_buff_flush(&t_2);
        argile_type_call_string((d)->type, ((((d)->maker)) ? ((d)->maker) : (c)), &t_2);
        if ((((((int)(d)->type) >> 30) & 1))) {
          argile_buff_flush(&s);
          argile_syntax_module_call((dtraw)->syntax, &t_2, (char *)0, ((argile_list_t *)0), &s);
          argile_buff_flush(&t_2);
          argile_buff_cat(&t_2, &s);
        } //;
#line 637 "argilectx.arg"
        argile_buff_flush(&s);
        if (((d)->ext)) {
          argile_syntax_module_call((((d)->nodecl) ? ((dnodecl)->syntax) : ((dext)->syntax)), &t_2, argile_def_gen_id(d), ((argile_list_t *)0), &s);
        } //;
        else {
          argile_syntax_module_call((dvar)->syntax, &t_2, argile_def_gen_id(d), (d)->syntax, &s);
        };
#line 643 "argilectx.arg"
        if (((s).ptr)) {
          if ((((d)->maker) && (((d)->maker)->comment))) {
            fprintf(f, "(:%s:)\n", ((d)->maker)->comment);
          } //;
#line 646 "argilectx.arg"
          fwrite((s).ptr, (s).len, 1, f);
        } //;
#line 647 "argilectx.arg"
        fputs(new_line, f);
      } //;
#line 648 "argilectx.arg"
      else if ((((d)->dtype == ARGILE_DEF_FUNC) && ((((d)->dval).code == NULL) || !((((d)->dval).code)->macro)))) {
#line 650 "argilectx.arg"
        argile_buff_flush(&t_2);
        argile_type_call_string((d)->type, ((((d)->maker)) ? ((d)->maker) : (c)), &t_2);
        if ((((((int)(d)->type) >> 31) & 1))) {
          argile_buff_flush(&s);
          argile_syntax_module_call((dtref)->syntax, &t_2, (char *)0, ((argile_list_t *)0), &s);
          argile_buff_flush(&t_2);
          argile_buff_cat(&t_2, &s);
        } //;
#line 657 "argilectx.arg"
        else if ((((((int)(d)->type) >> 30) & 1))) {
          argile_buff_flush(&s);
          argile_syntax_module_call((dtraw)->syntax, &t_2, (char *)0, ((argile_list_t *)0), &s);
          argile_buff_flush(&t_2);
          argile_buff_cat(&t_2, &s);
        } //;
#line 662 "argilectx.arg"
        argile_buff_flush(&s);
        if (((d)->ext)) {
          argile_syntax_module_call((((d)->nodecl) ? ((dnodecl)->syntax) : ((dext)->syntax)), &t_2, (char *)0, (d)->syntax, &s);
        } //;
        else {
          argile_syntax_module_call((dfunc)->syntax, &t_2, argile_def_gen_id(d), (d)->syntax, &s);
        };
#line 668 "argilectx.arg"
        if (((s).ptr)) {
          if ((((d)->maker) && (((d)->maker)->comment))) {
            fprintf(f, "(:%s:)\n", ((d)->maker)->comment);
          } //;
#line 671 "argilectx.arg"
          fwrite((s).ptr, (s).len, 1, f);
        } //;
#line 672 "argilectx.arg"
        fputs(new_line, f);
      } //;
#line 673 "argilectx.arg"
      else if (((d)->maker)) {
        argile_buff_flush(&s);
        argile_call_string((d)->maker, 0, &s);
        if (((s).ptr)) {
          if ((((d)->maker)->comment)) {
            fprintf(f, "(:%s:)\n", ((d)->maker)->comment);
          } //;
#line 679 "argilectx.arg"
          fwrite((s).ptr, (s).len, 1, f);
        } //;
#line 680 "argilectx.arg"
        fputs(new_line, f);
      } //;
    };
  } //;
#line 681 "argilectx.arg"
  if (((s).ptr)) {
    argile_dbg_free((s).ptr);
  } //;
#line 683 "argilectx.arg"
  if (((t_2).ptr)) {
    argile_dbg_free((t_2).ptr);
  } //;
#line 685 "argilectx.arg"
  (argile).use_colors = old;
}

#line 692 "argilectx.arg"
void argile_printf(char * fmt, ...)
/** :argile_printf <text fmt> [...]: -> nothing **/
{
#line 693 "argilectx.arg"
  va_list args;
#line 695 "argilectx.arg"
  int max = 0;

#line 694 "argilectx.arg"
  va_start(args, fmt);
  max = vsnprintf((char *)0, 0, fmt, args);
  va_end(args);
  if (((max)++ > 0)) {
    char * string = "";
#line 700 "argilectx.arg"
    int len = 0;

#line 698 "argilectx.arg"
    string = ((char *)argile_dbg_malloc(max));
    va_start(args, fmt);
    len = vsnprintf(string, max, fmt, args);
    va_end(args);
    if ((len < max)) {
      argile_output(string, len);
    } //;
#line 704 "argilectx.arg"
    else {
      argile_output(string, max);
    };
#line 706 "argilectx.arg"
    argile_dbg_free(string);
  } //;
}

#line 715 "argilectx.arg"
void argile_die(char * fmt_2, ...)
/** :argile_die <text fmt> [...]: -> nothing **/
{
#line 717 "argilectx.arg"
  va_list args;
#line 719 "argilectx.arg"
  int max = 0;

#line 716 "argilectx.arg"
  if (((argile).error)) {
#line 464 "./argrt/std.argl"
    return;
  } //;
#line 718 "argilectx.arg"
  va_start(args, fmt_2);
  max = vsnprintf((char *)0, 0, fmt_2, args);
  va_end(args);
  if (((max)++ > 0)) {
#line 726 "argilectx.arg"
    int len = 0;

#line 722 "argilectx.arg"
    if (((argile).linebuff)) {
      max += ((((argile).linebuff)->len * 2) + 64);
    } //;
#line 724 "argilectx.arg"
    (argile).error = ((char *)argile_dbg_malloc(max));
    va_start(args, fmt_2);
    len = vsnprintf((argile).error, max, fmt_2, args);
    va_end(args);
    if (((argile).linebuff)) {
      print_line((((argile).error) + len), (max - len));
    } //;
  } //;
}

#line 731 "argilectx.arg"
static void print_line(char * dst, int len)
/** :print line <text dst> <int len>: -> nothing **/
{
  int ofs = 0;
#line 736 "argilectx.arg"
  int i_2 = 0;

#line 732 "argilectx.arg"
  if (((argile).linebuff == NULL)) {
#line 464 "./argrt/std.argl"
    return;
  } //;
#line 733 "argilectx.arg"
  argile_buff_putc((argile).linebuff, '\0');
  ofs = snprintf(dst, len, "\n%s\n", ((argile).linebuff)->ptr);
  argile_buff_seek((argile).linebuff, (-1));
#line 737 "argilectx.arg"
  if (((((argile).loc).start).row == (((argile).loc).end).row)) {
    while ((i_2 < (((argile).loc).start).col)) {
      ofs += snprintf(((dst) + ofs), (len - ofs), "-");
      (i_2)++;
    };
  } //;
#line 741 "argilectx.arg"
  if ((i_2 < (((argile).loc).end).col)) {
    while ((i_2 < (((argile).loc).end).col)) {
      ofs += snprintf(((dst) + ofs), (len - ofs), "^");
      (i_2)++;
    };
  } //;
#line 745 "argilectx.arg"
  else {
    ofs += snprintf(((dst) + ofs), (len - ofs), "^");
  };
#line 747 "argilectx.arg"
  snprintf(((dst) + ofs), (len - ofs), "-> at \"%s\", line %d", ((((argile).input_name)) ? ((argile).input_name) : ("anonymous input")), (((argile).loc).end).row);
}

#line 757 "argilectx.arg"
void argile_die_again(char * fmt_3, ...)
/** :argile_die_again <text fmt> [...]: -> nothing **/
{
#line 758 "argilectx.arg"
  char * old_death = "";
  va_list args;
#line 761 "argilectx.arg"
  int max = 0;

#line 758 "argilectx.arg"
  old_death = (argile).error;
#line 760 "argilectx.arg"
  va_start(args, fmt_3);
  max = vsnprintf((char *)0, 0, fmt_3, args);
  va_end(args);
  if (((max)++ > 0)) {
#line 768 "argilectx.arg"
    int len_2 = 0;

#line 764 "argilectx.arg"
    if (((argile).linebuff)) {
      max += ((((argile).linebuff)->len * 2) + 32);
    } //;
#line 766 "argilectx.arg"
    (argile).error = ((char *)argile_dbg_malloc(max));
    va_start(args, fmt_3);
    len_2 = vsnprintf((argile).error, max, fmt_3, args);
    va_end(args);
    if (((argile).linebuff)) {
      print_line((((argile).error) + len_2), (max - len_2));
    } //;
  } //;
#line 772 "argilectx.arg"
  if (!((old_death == NULL))) {
#line 464 "./argrt/std.argl"
    argile_dbg_free(old_death);
  } //;
}

#line 781 "argilectx.arg"
void argile_die_hard(char * fmt_4, ...)
/** :argile_die_hard <text fmt> [...]: -> nothing **/
{
#line 783 "argilectx.arg"
  va_list args;

#line 782 "argilectx.arg"
  fprintf(stderr, "\n");
#line 784 "argilectx.arg"
  va_start(args, fmt_4);
  vfprintf(stderr, fmt_4, args);
  va_end(args);
  if ((((argile).linebuff) && (((argile).linebuff)->len != 0))) {
    int len_2 = 0;
    char * tmp = "";

#line 788 "argilectx.arg"
    len_2 = ((((argile).linebuff)->len * 2) + 32);
    tmp = ((char *)argile_dbg_malloc(len_2));
    print_line(tmp, len_2);
    fprintf(stderr, "%s\n", tmp);
    argile_dbg_free(tmp);
  } //;
#line 793 "argilectx.arg"
  {
#line 595 "./argrt/std.argl"
    fprintf(stderr, "\n");
    exit(1);
  };
}

#line 802 "argilectx.arg"
void argile_die_at(argile_call_t * at, char * fmt_5, ...)
/** :argile_die_at <call at> <text fmt> [...]: -> nothing **/
{
#line 804 "argilectx.arg"
  va_list args;
#line 806 "argilectx.arg"
  int max = 0;
#line 808 "argilectx.arg"
  argile_buff_t buf = ((argile_buff_t){0});

#line 803 "argilectx.arg"
  if (((argile).error)) {
#line 464 "./argrt/std.argl"
    return;
  } //;
#line 805 "argilectx.arg"
  va_start(args, fmt_5);
  max = vsnprintf((char *)0, 0, fmt_5, args);
  va_end(args);
#line 809 "argilectx.arg"
  if (((max)++ > 0)) {
#line 838 "argilectx.arg"
    int len_2 = 0;

#line 810 "argilectx.arg"
    argile_buff_puts(&buf, "\n  ");
    if (((at)->owner)) {
      argile_buff_putc(&buf, *&("(")[0]);
    } //;
#line 813 "argilectx.arg"
    argile_call_string(at, 1, &buf);
    if (((at)->owner)) {
      argile_buff_putc(&buf, *&(")")[0]);
    } //;
#line 816 "argilectx.arg"
    if ((((at)->context != ARGILE_TYPE_NOTHING) && ((at)->context != ARGILE_TYPE_ANYTHING))) {
#line 818 "argilectx.arg"
      argile_buff_puts(&buf, "\n(expected return type: ");
      argile_typename((at)->context, &buf, (at)->scope);
      argile_buff_puts(&buf, ")");
    } //;
#line 821 "argilectx.arg"
    argile_buff_puts(&buf, "\n=> at \"");
    if ((((at)->scope)->input)) {
      argile_buff_puts(&buf, ((at)->scope)->input);
    } //;
#line 824 "argilectx.arg"
    else {
      argile_buff_puts(&buf, "anonymous input");
    };
#line 826 "argilectx.arg"
    argile_buff_puts(&buf, "\", from line ");
    argile_buff_putn(&buf, (((at)->loc).start).row);
    argile_buff_puts(&buf, " column ");
    argile_buff_putn(&buf, (((at)->loc).start).col);
    argile_buff_puts(&buf, ", to line ");
    argile_buff_putn(&buf, (((at)->loc).end).row);
    argile_buff_puts(&buf, " column ");
    argile_buff_putn(&buf, (((at)->loc).end).col);
    argile_buff_putc(&buf, '\0');
    max += (buf).len;
    (argile).error = ((char *)argile_dbg_malloc(max));
    va_start(args, fmt_5);
    len_2 = vsnprintf((argile).error, max, fmt_5, args);
    snprintf((((argile).error) + len_2), (max - len_2), "%s", (buf).ptr);
    va_end(args);
    argile_dbg_free((buf).ptr);
    (argile).killer = at;
  } //;
}

#line 848 "argilectx.arg"
void argile_resurrect()
/** :argile_resurrect: -> nothing **/
{
#line 849 "argilectx.arg"
  if (((argile).error)) {
    argile_dbg_free((argile).error);
    (argile).error = (char *)0;
  } //;
}

#line 864 "argilectx.arg"
void argile_def(argile_list_t * syntax, int del_syntax, argile_type_t type, argile_def_type_t dtype, void * dval)
/** :argile_def <list of (argile syntax) syntax> <int del_syntax> <argile type type> <def type dtype> <any dval>: -> nothing **/
{
#line 866 "argilectx.arg"
  if (!(((argile).main))) {
    (argile).main = argile_code_new(((argile_code_t *)0), ((argile_list_t *)0));
  } //;
#line 868 "argilectx.arg"
  argile_code_def((argile).main, argile_def_new(syntax, del_syntax, type, ((argile_call_t *)0), dtype, dval), 1);
}

#line 879 "argilectx.arg"
void argile_bind(char * synstr, char * modname, char * name_2)
/** :argile_bind <text synstr> <text modname> <text name>: -> nothing **/
{
#line 883 "argilectx.arg"
  argile_list_t * syn;
  unsigned char comp;
  argile_module_t * mod = ((argile_module_t *)0);
  argile_bind_t * bind = ((argile_bind_t *)0);

#line 880 "argilectx.arg"
  if (((argile).error)) {
#line 464 "./argrt/std.argl"
    return;
  } //;
#line 881 "argilectx.arg"
  if (!(((argile).main))) {
    (argile).main = argile_code_new(((argile_code_t *)0), ((argile_list_t *)0));
  } //;
#line 887 "argilectx.arg"
  if (((((syn = argile_syntax_parse(synstr)) && (comp = (argile_syntax_compile_params(syn, (argile).main, ((argile_call_t *)0))))) && (mod = argile_getmod(modname))) && (bind = argile_module_getbind(mod, name_2)))) {
#line 891 "argilectx.arg"
    argile_type_t type_2;

#line 891 "argilectx.arg"
    type_2 = ((((bind)->type)) ? (*(bind)->type) : (ARGILE_TYPE_NOTHING));
    if ((bind)->deftype) {
      if (((bind)->gettype)) {
        type_2 = (*(bind)->gettype)(NULL);
      } //;
#line 895 "argilectx.arg"
      argile_def(syn, 1, (argile_type_t)ARGILE_TYPE_TYPE, ARGILE_DEF_TYPE, ((void *)((long)type_2)));
    } //;
    else {
      argile_def(syn, 1, type_2, ARGILE_DEF_BIND, bind);
    };
  } //;
#line 899 "argilectx.arg"
  else if ((syn)) {
    if (!(comp)) {
      argile_die("binding: %s some parameter type could not compile", synstr);
    } //;
#line 902 "argilectx.arg"
    else if ((mod == NULL)) {
      argile_die("binding: %s: no such module", modname);
    } //;
#line 904 "argilectx.arg"
    else if ((bind == NULL)) {
      argile_die("binding: %s: no such binding in module %s", name_2, modname);
    } //;
#line 906 "argilectx.arg"
    argile_list_del(syn);
  } //;
}

#line 916 "argilectx.arg"
void argile_deftype(char * synstr_2, argile_type_t t_2)
/** :argile_deftype <text synstr> <argile type t>: -> nothing **/
{
  argile_list_t * syn;

#line 917 "argilectx.arg"
  if (!(((argile).main))) {
    (argile).main = argile_code_new(((argile_code_t *)0), ((argile_list_t *)0));
  } //;
#line 919 "argilectx.arg"
  syn = argile_syntax_parse(synstr_2);
  if (((syn) && (argile_syntax_compile_params(syn, (argile).main, ((argile_call_t *)0))))) {
#line 922 "argilectx.arg"
    argile_def(syn, 1, (argile_type_t)ARGILE_TYPE_TYPE, ARGILE_DEF_TYPE, ((void *)((long)t_2)));
  } //;
  else if ((syn)) {
    argile_die("type definition: %s some parameter type did not compile", synstr_2);
    argile_list_del(syn);
  } //;
}

#line 934 "argilectx.arg"
void argile_implicitize()
/** :argile_implicitize: -> nothing **/
{
#line 936 "argilectx.arg"
  argile_list_t * ldef;

#line 935 "argilectx.arg"
  if (((argile).main == NULL)) {
#line 464 "./argrt/std.argl"
    return;
  } //;
#line 936 "argilectx.arg"
  for (ldef = ((argile).main)->defs; (ldef); ldef = ((argile_list_t *)ldef)->next) {
    (*((argile_def_t * *)&((argile_list_t *)ldef)->data))->implicit = 1;
  };
#line 938 "argilectx.arg"
  ((argile).main)->has_weak_defs = 1;
  ((argile).stat).binds = 0;
  ((argile).stat).num_match_try = 0;
}

#line 950 "argilectx.arg"
int argile_typename(argile_type_t type_2, argile_buff_t * buf, argile_code_t * scope)
/** :argile_typename <argile type type> <buff buf> <argile code scope>: -> int **/
{
#line 951 "argilectx.arg"
  argile_buff_t tmp = ((argile_buff_t){0});
  argile_def_t * dtyperef = ((argile_def_t *)0);
  argile_def_t * dtyperaw = ((argile_def_t *)0);
  argile_type_info_t * info = ((argile_type_info_t *)0);
#line 971 "argilectx.arg"
  argile_list_t * cur;
#line 971 "argilectx.arg"
  argile_list_t * prev;
#line 971 "argilectx.arg"
  argile_list_t * next;

#line 952 "argilectx.arg"
  dtyperef = argile_find_def("std", "typeref", "", 0);
  dtyperaw = argile_find_def("std", "typeraw", "", 0);
  info = argile_type_get_info(type_2);
  if (((info) && ((info)->ttype == ARGILE_TYPE_KIND_CTYPE))) {
    if (((((info)->tval).t_ctype).generator)) {
      unsigned char old;

#line 957 "argilectx.arg"
      old = (argile).skip_codes;
      (argile).skip_codes = 1;
      argile_buff_flush(&tmp);
      argile_call_string((((info)->tval).t_ctype).generator, 0, &tmp);
      (argile).skip_codes = old;
      if ((((((int)type_2) >> 31) & 1))) {
        write_ref_or_raw_in_with(&tmp, buf, dtyperef, "reference");
      } //;
#line 964 "argilectx.arg"
      else if ((((((int)type_2) >> 30) & 1))) {
        write_ref_or_raw_in_with(&tmp, buf, dtyperaw, "structure");
      } //;
#line 966 "argilectx.arg"
      else {
        argile_buff_cat(buf, &tmp);
      };
#line 968 "argilectx.arg"
      if (((tmp).ptr)) {
        argile_dbg_free((tmp).ptr);
      } //;
#line 970 "argilectx.arg"
      return 1;
    } //;
  } //;
#line 972 "argilectx.arg"
  argile_code_getdef(scope, ((argile_call_t *)0), &prev, &next);
  while ((cur = argile_code_nextdef(&scope, &prev, &next))) {
    argile_def_t * d = ((argile_def_t *)0);

#line 974 "argilectx.arg"
    d = *((argile_def_t * *)&((argile_list_t *)cur)->data);
    if ((((d)->dtype != ARGILE_DEF_TYPE) || ((d)->type != ARGILE_TYPE_TYPE))) {
#line 464 "./argrt/std.argl"
      continue;
    } //;
#line 977 "argilectx.arg"
    if ((((d)->dval).type == (((int)type_2) & ((1 << 30) - 1)))) {
      if ((((((int)type_2) >> 31) & 1))) {
        argile_buff_flush(&tmp);
        argile_syntax_string((d)->syntax, &tmp);
        write_ref_or_raw_in_with(&tmp, buf, dtyperef, "reference");
      } //;
#line 982 "argilectx.arg"
      else if ((((((int)type_2) >> 30) & 1))) {
        argile_buff_flush(&tmp);
        argile_syntax_string((d)->syntax, &tmp);
        write_ref_or_raw_in_with(&tmp, buf, dtyperaw, "structure");
      } //;
#line 986 "argilectx.arg"
      else {
        argile_syntax_string((d)->syntax, buf);
      };
#line 988 "argilectx.arg"
      if (((tmp).ptr)) {
        argile_dbg_free((tmp).ptr);
      } //;
#line 990 "argilectx.arg"
      return 1;
    } //;
  };
#line 991 "argilectx.arg"
  argile_buff_putn(buf, ((int)type_2));
#line 1000 "argilectx.arg"
  return 0;
}

#line 1008 "argilectx.arg"
argile_module_t * argile_getmod(char * name_3)
/** :argile_getmod <text name>: -> (argile) module **/
{
#line 1009 "argilectx.arg"
  argile_list_t * lmod;

#line 1009 "argilectx.arg"
  for (lmod = (argile).mods; (lmod); lmod = ((argile_list_t *)lmod)->next) {
    argile_module_t * mod = ((argile_module_t *)0);

#line 1010 "argilectx.arg"
    mod = *((argile_module_t * *)&((argile_list_t *)lmod)->data);
    if ((strcmp(name_3, (mod)->name) == 0)) {
#line 464 "./argrt/std.argl"
      return mod;
    } //;
  };
#line 1012 "argilectx.arg"
  return ((argile_module_t *)0);
}

#line 1020 "argilectx.arg"
void argile_addmod(argile_module_t * mod)
/** :argile_addmod <module mod>: -> nothing **/
{
#line 1021 "argilectx.arg"
  argile_list_prepend(&(argile).mods, argile_list_new(mod, (void *)&argile_module_del));
}

#line 1031 "argilectx.arg"
argile_module_t * argile_loadmod(char * name_4)
/** :argile_loadmod <text name>: -> (argile) module **/
{
#line 1032 "argilectx.arg"
  char * orig = "";
#line 1038 "argilectx.arg"
  char( file[256]);
#line 1041 "argilectx.arg"
  char * base = "";
#line 1050 "argilectx.arg"
  int len_2 = 0;
  int end = 0;
  char( tmp[128]);
#line 1064 "argilectx.arg"
  argile_module_t * mod_2 = ((argile_module_t *)0);
#line 1089 "argilectx.arg"
  argile_list_t * cur;

#line 1032 "argilectx.arg"
  orig = name_4;
#line 1034 "argilectx.arg"
  if ((argile).verbose) {
    fprintf(stderr, "   loading module %s\n", name_4);
  } //;
#line 1039 "argilectx.arg"
  snprintf(((char *)file), sizeof(file), "%s", name_4);
#line 1041 "argilectx.arg"
  base = strrchr(name_4, '/');
  if ((base == NULL)) {
    base = name_4;
  } //;
#line 1044 "argilectx.arg"
  else {
    (base)++;
    if ((*&(base)[0] == 0)) {
      argile_die("load module: cannot load directory ('%s')", name_4);
      return ((argile_module_t *)0);
    } //;
  };
#line 1050 "argilectx.arg"
  len_2 = strlen(base);
  end = ends_by(base, len_2, ".so");
#line 1053 "argilectx.arg"
  if ((end != 0)) {
    len_2 -= end;
    if ((len_2 >= sizeof(tmp))) {
      len_2 = (sizeof(tmp) - 1);
    } //;
#line 1057 "argilectx.arg"
    memcpy(tmp, base, len_2);
    *&(tmp)[len_2] = '\0';
    name_4 = ((char *)tmp);
  } //;
#line 1060 "argilectx.arg"
  else {
    snprintf(((char *)file), sizeof(file), "%s%s", name_4, ".so");
    name_4 = base;
  };
  mod_2 = argile_getmod(name_4);
  if (!((mod_2 == NULL))) {
#line 464 "./argrt/std.argl"
    return mod_2;
  } //;
#line 1067 "argilectx.arg"
  if ((((((argile).som_path) && ((file)[0] != '/')) && (strncmp(((char *)file), "./", 2))) && (strncmp(((char *)file), "../", 3)))) {
#line 1069 "argilectx.arg"
    argile_list_t * cur_2;

#line 1069 "argilectx.arg"
    for (cur_2 = (argile).som_path; (cur_2); cur_2 = ((argile_list_t *)cur_2)->next) {
#line 1071 "argilectx.arg"
      char * try = "";
#line 1073 "argilectx.arg"
      struct stat st;

#line 1070 "argilectx.arg"
      len_2 = (((strlen(*((char * *)&((argile_list_t *)cur_2)->data)) + 1) + strlen(((char *)file))) + 1);
      try = ((char *)argile_dbg_malloc(len_2));
      snprintf(try, len_2, "%s/%s", *((char * *)&((argile_list_t *)cur_2)->data), file);
#line 1074 "argilectx.arg"
      if (!((stat(try, &st)))) {
        snprintf(((char *)file), sizeof(file), "%s", try);
        argile_dbg_free(try);
        break;
      } //;
#line 1078 "argilectx.arg"
      argile_dbg_free(try);
    };
#line 1079 "argilectx.arg"
    if ((cur_2 == NULL)) {
      argile_die("cannot find module '%s'", orig);
      return ((argile_module_t *)0);
    } //;
  } //;
#line 1083 "argilectx.arg"
  mod_2 = argile_module_new(name_4, ((char *)file));
  if (((argile).error)) {
    argile_module_del(mod_2);
    return ((argile_module_t *)0);
  } //;
#line 1087 "argilectx.arg"
  if ((argile).verbose) {
    fprintf(stderr, "   loaded  module(%s) %s\n", name_4, file);
  } //;
#line 1089 "argilectx.arg"
  for (cur = (mod_2)->binds; (cur); cur = ((argile_list_t *)cur)->next) {
    argile_module_loadbind(mod_2, *((argile_bind_t * *)&((argile_list_t *)cur)->data));
    if (((argile).error)) {
      argile_module_del(mod_2);
      return ((argile_module_t *)0);
    } //;
  };
#line 1094 "argilectx.arg"
  argile_addmod(mod_2);
  return mod_2;
}

#line 1097 "argilectx.arg"
static int ends_by(char * str, int n, char * end)
/** :<text str> ends by <int n> <text end>: -> int **/
{
#line 1098 "argilectx.arg"
  int e = 0;

#line 1098 "argilectx.arg"
  e = strlen(end);
  if (((n > e) && (strcmp(((str) + (n - e)), end) == 0))) {
#line 1099 "argilectx.arg"
    return e;
  } //;
#line 1100 "argilectx.arg"
  return 0;
}

#line 1108 "argilectx.arg"
argile_file_t * argile_getfile(argile_file_t * p_argile_file)
/** :argile_getfile <file>: -> (argile) file **/
{
#line 1109 "argilectx.arg"
  argile_list_t * lf;

#line 1109 "argilectx.arg"
  lf = argile_list_search((argile).used, p_argile_file, (void *)&argile_file_eq);
  if ((lf == NULL)) {
#line 464 "./argrt/std.argl"
    return ((argile_file_t *)0);
  } //;
#line 1111 "argilectx.arg"
  return *((argile_file_t * *)&((argile_list_t *)lf)->data);
}

#line 1118 "argilectx.arg"
void argile_addfile(argile_file_t * p_argile_file_2)
/** :argile_addfile <file>: -> nothing **/
{
#line 1119 "argilectx.arg"
  argile_list_prepend(&(argile).used, argile_list_new(p_argile_file_2, (void *)&argile_file_del));
}

#line 1128 "argilectx.arg"
argile_file_t * argile_loadfile(char * path)
/** :argile_loadfile <text path>: -> (argile) file **/
{
#line 1134 "argilectx.arg"
  argile_file_t * file = ((argile_file_t *)0);
#line 1142 "argilectx.arg"
  argile_file_t * old = ((argile_file_t *)0);

#line 1129 "argilectx.arg"
  if ((argile).verbose) {
    {
#line 1133 "argilectx.arg"
      int i = 0;

#line 1133 "argilectx.arg"
      for (i = 0; ((i <= ((argile).depth - 1))); (i)++) {
#line 1133 "argilectx.arg"
        fprintf(stderr, " ");
      };
    };
#line 1131 "argilectx.arg"
    fprintf(stderr, "   loading file %s\n", path);
  } //;
#line 1134 "argilectx.arg"
  file = try_new_file(path);
  if ((file == NULL)) {
    argile_die("include file: %s: could not find file", path);
    return ((argile_file_t *)0);
  } //;
#line 1138 "argilectx.arg"
  if (((file)->error != 0)) {
    argile_die("%s: %s", path, strerror((file)->error));
    argile_file_del(file);
    return ((argile_file_t *)0);
  } //;
#line 1142 "argilectx.arg"
  old = argile_getfile(file);
  if ((old)) {
    argile_file_del(file);
    add_include((old)->path);
    return old;
  } //;
#line 1161 "argilectx.arg"
  argile_addfile(file);
  argile_file_load(file);
  if (((argile).error)) {
    argile_list_t * lf;

#line 1164 "argilectx.arg"
    lf = (argile).used;
    argile_list_rm(&(argile).used, lf);
    ((argile_list_t *)lf)->next = ((argile_list_t *)0);
    argile_list_del(lf);
    return ((argile_file_t *)0);
  } //;
#line 1169 "argilectx.arg"
  add_include((file)->path);
  if ((argile).verbose) {
    {
#line 1133 "argilectx.arg"
      int i = 0;

#line 1133 "argilectx.arg"
      for (i = 0; ((i <= ((argile).depth - 1))); (i)++) {
#line 1133 "argilectx.arg"
        fprintf(stderr, " ");
      };
    };
#line 1172 "argilectx.arg"
    fprintf(stderr, "   loaded  file %s\n", (file)->path);
  } //;
#line 1173 "argilectx.arg"
  return file;
}

#line 1175 "argilectx.arg"
static argile_file_t * try_new_file(char * path_2)
/** :try new file <text path>: -> (argile) file **/
{
#line 1179 "argilectx.arg"
  char * base = (char *)0;
  int baselen = 0;
#line 1182 "argilectx.arg"
  argile_list_t * lf;
#line 1194 "argilectx.arg"
  int extlen = 0;
  int libextlen = 0;
#line 1198 "argilectx.arg"
  int pathlen = 0;
#line 1201 "argilectx.arg"
  argile_file_t * file = ((argile_file_t *)0);
#line 1205 "argilectx.arg"
  argile_list_t * lp;

#line 1176 "argilectx.arg"
  if ((*&(path_2)[0] == '/')) {
    return argile_file_new(path_2, ((struct stat*)0));
  } //;
#line 1182 "argilectx.arg"
  lf = (argile).used;
  for (; (lf); lf = ((argile_list_t *)lf)->next) {
    if (((*((argile_file_t * *)&((argile_list_t *)lf)->data))->code == (argile).main)) {
      base = (*((argile_file_t * *)&((argile_list_t *)lf)->data))->path;
    } //;
  };
#line 1187 "argilectx.arg"
  if ((base)) {
    char * b = "";

#line 1188 "argilectx.arg"
    b = strrchr(base, '/');
    if ((b)) {
      baselen = ((b) - base);
    } //;
#line 1191 "argilectx.arg"
    else {
      base = ".";
#line 1192 "argilectx.arg"
      baselen = 1;
    };
  } //;
#line 1194 "argilectx.arg"
  extlen = strlen(".arg");
  libextlen = strlen(".argl");
  if ((libextlen > extlen)) {
    extlen = libextlen;
  } //;
#line 1198 "argilectx.arg"
  pathlen = (((1 + strlen(path_2)) + extlen) + 1);
#line 1202 "argilectx.arg"
  if (((base) && (file = try_in_dir(path_2, pathlen, base, baselen)))) {
    return file;
  } //;
  lp = (argile).file_path;
  for (; (lp); lp = ((argile_list_t *)lp)->next) {
    char * dirpath = "";
    int dirlen = 0;

#line 1207 "argilectx.arg"
    dirpath = *((char * *)&((argile_list_t *)lp)->data);
    dirlen = strlen(dirpath);
    file = try_in_dir(path_2, pathlen, dirpath, dirlen);
    if ((file != NULL)) {
#line 464 "./argrt/std.argl"
      return file;
    } //;
  };
#line 1288 "argilectx.arg"
  return ((argile_file_t *)0);
}

#line 1298 "argilectx.arg"
void argile_push_output(argile_inout_t output, void * output_data)
/** :argile_push_output <inout output> <any output_data>: -> nothing **/
{
#line 1299 "argilectx.arg"
  void *(* ptrs);

#line 1299 "argilectx.arg"
  ptrs = ((void *(*))argile_dbg_malloc((4 * sizeof(void *))));
  *&(ptrs)[0] = (argile).output;
  *&(ptrs)[1] = (argile).output_data;
  *&(ptrs)[2] = (argile).output_name;
  *&(ptrs)[3] = ((void *)((long)(argile).output_line));
  argile_list_prepend(&(argile).outctx, argile_list_new(ptrs, (void *)&argile_dbg_free));
  (argile).output = output;
  (argile).output_data = output_data;
  (argile).output_line = 1;
}

#line 1314 "argilectx.arg"
void argile_pop_output()
/** :argile_pop_output: -> nothing **/
{
#line 1315 "argilectx.arg"
  argile_list_t * h;
  void *(* p);

#line 1315 "argilectx.arg"
  h = argile_list_pop(&(argile).outctx);
  p = ((void *(*))*((void * *)&((argile_list_t *)h)->data.u_anything));
  (argile).output = ((argile_inout_t)(p)[0]);
  (argile).output_data = (p)[1];
  (argile).output_name = ((char *)(p)[2]);
  (argile).output_line = ((int)((long)(p)[3]));
  argile_list_del(h);
}

#line 1329 "argilectx.arg"
void argile_push_color(argile_buff_t * out, char * color)
/** :argile_push_color <buff out> <text color>: -> nothing **/
{
#line 1330 "argilectx.arg"
  if ((((argile).colors == NULL) || (strcmp(color, *((char * *)&((argile_list_t *)(argile).colors)->data)) != 0))) {
    if ((argile).use_colors) {
      argile_buff_puts(out, color);
    } //;
#line 1333 "argilectx.arg"
    if ((argile).daltonism) {
      argile_buff_puts(out, convert_to_daltonism(color));
    } //;
  } //;
#line 1335 "argilectx.arg"
  argile_list_prepend(&(argile).colors, argile_list_new(color, ((argile_deleter_t)0)));
}

#line 1337 "argilectx.arg"
static char * convert_to_daltonism(char * colour)
/** :convert <text colour> to daltonism: -> text **/
{
#line 1338 "argilectx.arg"
  if ((strcmp(colour, "[01;32m") == 0)) {
#line 464 "./argrt/std.argl"
    return "(:O:)";
  } //;
#line 1339 "argilectx.arg"
  if ((strcmp(colour, "[01;31m") == 0)) {
#line 464 "./argrt/std.argl"
    return "(:E:)";
  } //;
#line 1340 "argilectx.arg"
  if ((strcmp(colour, "[01;33m") == 0)) {
#line 464 "./argrt/std.argl"
    return "(:R:)";
  } //;
#line 1341 "argilectx.arg"
  if ((strcmp(colour, "[00;32m") == 0)) {
#line 464 "./argrt/std.argl"
    return "(:W:)";
  } //;
#line 1342 "argilectx.arg"
  if ((strcmp(colour, "[01;37m") == 0)) {
#line 464 "./argrt/std.argl"
    return "(:U:)";
  } //;
#line 1343 "argilectx.arg"
  return "";
}

#line 1352 "argilectx.arg"
void argile_pop_color(argile_buff_t * out_2)
/** :argile_pop_color <buff out>: -> nothing **/
{
#line 1353 "argilectx.arg"
  argile_list_t * head;

#line 1353 "argilectx.arg"
  head = argile_list_pop(&(argile).colors);
  if (((argile).colors)) {
    char * cur = "";

#line 1355 "argilectx.arg"
    cur = *((char * *)&((argile_list_t *)(argile).colors)->data);
    if (((strcmp(cur, *((char * *)&((argile_list_t *)head)->data)) != 0) && (argile).use_colors)) {
      argile_buff_puts(out_2, cur);
    } //;
#line 1358 "argilectx.arg"
    if ((argile).daltonism) {
      argile_buff_puts(out_2, convert_to_daltonism(cur));
    } //;
  } //;
#line 1360 "argilectx.arg"
  else if ((argile).use_colors) {
    argile_buff_puts(out_2, "[0m");
  } //;
#line 1362 "argilectx.arg"
  argile_list_del(head);
}

#line 1370 "argilectx.arg"
void argile_push_token(int tok)
/** :argile_push_token <int tok>: -> nothing **/
{
#line 1371 "argilectx.arg"
  argile_list_append(&(argile).last_token, argile_list_new(((void *)((long)tok)), ((argile_deleter_t)0)));
  if (((argile).tokens == NULL)) {
    (argile).tokens = (argile).last_token;
  } //;
}

#line 1380 "argilectx.arg"
int argile_pop_token()
/** :argile_pop_token: -> int **/
{
  argile_list_t * lt;
#line 1386 "argilectx.arg"
  int t_2 = 0;

#line 1381 "argilectx.arg"
  if (((argile).tokens == NULL)) {
    return 0;
  } //;
#line 1383 "argilectx.arg"
  lt = argile_list_pop(&(argile).tokens);
  if (((argile).tokens == NULL)) {
    (argile).last_token = ((argile_list_t *)0);
  } //;
#line 1386 "argilectx.arg"
  t_2 = *((int *)&((argile_list_t *)lt)->data.u_int);
  argile_list_del(lt);
  return t_2;
}

#line 1397 "argilectx.arg"
void argile_push_optoken(int token)
/** :argile_push_optoken <int token>: -> nothing **/
{
#line 1398 "argilectx.arg"
  argile_list_append(&(argile).last_optoken, argile_list_new(((void *)((long)token)), ((argile_deleter_t)0)));
  if (((argile).ops_tokens == NULL)) {
    (argile).ops_tokens = (argile).last_optoken;
  } //;
}

#line 1408 "argilectx.arg"
int argile_pop_optoken()
/** :argile_pop_optoken: -> int **/
{
  argile_list_t * lt;
#line 1414 "argilectx.arg"
  int t_2 = 0;

#line 1409 "argilectx.arg"
  if (((argile).ops_tokens == NULL)) {
    return 0;
  } //;
#line 1411 "argilectx.arg"
  lt = argile_list_pop(&(argile).ops_tokens);
  if (((argile).ops_tokens == NULL)) {
    (argile).last_optoken = ((argile_list_t *)0);
  } //;
#line 1414 "argilectx.arg"
  t_2 = *((int *)&((argile_list_t *)lt)->data.u_int);
  argile_list_del(lt);
  return t_2;
}

#line 1424 "argilectx.arg"
void argile_push_op(char * op)
/** :argile_push_op <text op>: -> nothing **/
{
#line 1425 "argilectx.arg"
  argile_list_append(&(argile).last_op, argile_list_new(op, ((argile_deleter_t)0)));
  if (((argile).ops == NULL)) {
    (argile).ops = (argile).last_op;
  } //;
}

#line 1435 "argilectx.arg"
char * argile_pop_op()
/** :argile_pop_op: -> text **/
{
  argile_list_t * lv;
#line 1441 "argilectx.arg"
  char * val = "";

#line 1436 "argilectx.arg"
  if (((argile).ops == NULL)) {
    return (char *)0;
  } //;
#line 1438 "argilectx.arg"
  lv = argile_list_pop(&(argile).ops);
  if (((argile).ops == NULL)) {
    (argile).last_op = ((argile_list_t *)0);
  } //;
#line 1441 "argilectx.arg"
  val = *((char * *)&((argile_list_t *)lv)->data);
  argile_list_del(lv);
  return val;
}

#line 1451 "argilectx.arg"
void argile_push_indent(int indent)
/** :argile_push_indent <int indent>: -> nothing **/
{
#line 1452 "argilectx.arg"
  if (((indent > -1) && (indent == argile_top_indent()))) {
#line 464 "./argrt/std.argl"
    return;
  } //;
#line 1453 "argilectx.arg"
  argile_list_prepend(&(argile).indents, argile_list_new(((void *)((long)indent)), ((argile_deleter_t)0)));
}

#line 1461 "argilectx.arg"
int argile_top_indent()
/** :argile_top_indent: -> int **/
{
#line 1462 "argilectx.arg"
  if (((argile).indents == NULL)) {
#line 464 "./argrt/std.argl"
    return -2;
  } //;
#line 1463 "argilectx.arg"
  return *((int *)&((argile_list_t *)(argile).indents)->data.u_int);
}

#line 1471 "argilectx.arg"
int argile_pop_indent()
/** :argile_pop_indent: -> int **/
{
  argile_list_t * ltop;
  int top = 0;

#line 1472 "argilectx.arg"
  if (((argile).indents == NULL)) {
    return -2;
  } //;
#line 1474 "argilectx.arg"
  ltop = argile_list_pop(&(argile).indents);
  top = *((int *)&((argile_list_t *)ltop)->data.u_int);
  argile_list_del(ltop);
  return top;
}

#line 1487 "argilectx.arg"
int argile_yyinput(char * buf_2, int len_2)
/** :argile_yyinput <text buf> <int len>: -> int **/
{
#line 1488 "argilectx.arg"
  if (((argile).input_ended || ((argile).input == NULL))) {
    return 0;
  } //;
#line 1490 "argilectx.arg"
  return (*(argile).input)((argile).input_data, buf_2, len_2);
}

#line 1505 "argilectx.arg"
int argile_yylex_wrapper()
/** :argile_yylex_wrapper: -> int **/
{
#line 1506 "argilectx.arg"
  if (((argile).error)) {
    return 0;
  } //;
#line 1508 "argilectx.arg"
  if (((argile).tokens)) {
    return argile_pop_token();
  } //;
#line 1510 "argilectx.arg"
  if (((argile).ops_tokens)) {
#line 1512 "argilectx.arg"
    *&argile_yylval.string = argile_pop_op();
    return argile_pop_optoken();
  } //;
#line 1514 "argilectx.arg"
  if ((argile).input_ended) {
    return 0;
  } //;
#line 1516 "argilectx.arg"
  return argile_yylex();
}

#line 1539 "argilectx.arg"
void argile_add_leak(void * data_2)
/** :argile_add_leak <any data>: -> nothing **/
{
#line 1540 "argilectx.arg"
  argile_list_prepend(&(argile).leaks, argile_list_new(data_2, (void *)&argile_dbg_free));
}

#line 1548 "argilectx.arg"
void argile_rm_leak(void * data_3)
/** :argile_rm_leak <any data>: -> nothing **/
{
#line 1549 "argilectx.arg"
  argile_list_t * found;

#line 1549 "argilectx.arg"
  found = argile_list_search((argile).leaks, data_3, ((argile_comparer_t)0));
  if ((found)) {
    argile_list_rm(&(argile).leaks, found);
    ((argile_list_t *)found)->del = NULL;
    argile_list_del(found);
  } //;
}

#line 1561 "argilectx.arg"
void argile_choke_leaks()
/** :argile_choke_leaks: -> nothing **/
{
#line 1562 "argilectx.arg"
  argile_list_del((argile).leaks);
  (argile).leaks = ((argile_list_t *)0);
}

#line 1571 "argilectx.arg"
void argile_forget_leaks()
/** :argile_forget_leaks: -> nothing **/
{
#line 1572 "argilectx.arg"
  argile_list_t * ll;
#line 1572 "argilectx.arg"
  argile_list_t * nx;

#line 1573 "argilectx.arg"
  for (ll = (argile).leaks; (ll); ll = nx) {
    nx = ((argile_list_t *)ll)->next;
    argile_dbg_free(ll);
  };
#line 1576 "argilectx.arg"
  (argile).leaks = ((argile_list_t *)0);
}

#line 1583 "argilectx.arg"
void argile_gen_ref(argile_type_t context, argile_type_t type_3)
/** :argile_gen_ref <argile type context> <argile type type>: -> nothing **/
{
#line 1584 "argilectx.arg"
  unsigned char is_ref;
  unsigned char is_raw;
#line 1587 "argilectx.arg"
  unsigned char in_ref;
  unsigned char in_raw;

#line 1584 "argilectx.arg"
  is_ref = (((((int)type_3) >> 31) & 1));
  is_raw = (((((int)type_3) >> 30) & 1));
#line 1587 "argilectx.arg"
  in_ref = (((((int)context) >> 31) & 1));
  in_raw = (((((int)context) >> 30) & 1));
#line 1590 "argilectx.arg"
  if ((in_ref && !(is_ref))) {
    argile_ref(-1);
  } //;
#line 1592 "argilectx.arg"
  if ((is_ref && !(in_ref))) {
    argile_ref(1);
  } //;
#line 1594 "argilectx.arg"
  if ((in_raw && !(is_raw))) {
    argile_ref(1);
  } //;
#line 1596 "argilectx.arg"
  if ((is_raw && !(in_raw))) {
    argile_ref(-1);
  } //;
}

#line 1605 "argilectx.arg"
void argile_ref(int count)
/** :argile_ref <int count>: -> nothing **/
{
#line 1606 "argilectx.arg"
  (argile).refcount += count;
}

#line 1614 "argilectx.arg"
void argile_flush_refs()
/** :argile_flush_refs: -> nothing **/
{
#line 1615 "argilectx.arg"
  if (((argile).refcount < 0)) {
    while ((((argile).refcount)++ != 0)) {
      (*(argile).output)((argile).output_data, "&", 1);
    };
  } //;
#line 1618 "argilectx.arg"
  else if (((argile).refcount > 0)) {
    while ((((argile).refcount)-- != 0)) {
      (*(argile).output)((argile).output_data, "*", 1);
    };
  } //;
#line 1621 "argilectx.arg"
  (argile).refcount = 0;
}

#line 1629 "argilectx.arg"
void argile_output(char * buf_3, int len_3)
/** :argile_output <text buf> <int len>: -> nothing **/
{
#line 1637 "argilectx.arg"
  int i_2 = 0;

#line 1630 "argilectx.arg"
  if (((((argile).gen_lines != 0) && ((argile).outctx == NULL)) && (((argile).next_input_buff)->len > 0))) {
#line 1632 "argilectx.arg"
    unsigned int n_2 = 0;

#line 1632 "argilectx.arg"
    n_2 = ((argile).next_input_buff)->len;
    ((argile).next_input_buff)->len = 0;
    argile_output(((argile).next_input_buff)->ptr, ((int)n_2));
    ((argile).last_input_line)--;
  } //;
#line 1636 "argilectx.arg"
  argile_flush_refs();
  for (i_2 = 0; ((i_2 <= (len_3 - 1))); (i_2)++) {
    if ((*&(buf_3)[i_2] == '\n')) {
      ((argile).output_line)++;
      ((argile).last_input_line)++;
    } //;
  };
#line 1641 "argilectx.arg"
  (*(argile).output)((argile).output_data, buf_3, len_3);
}

#line 1648 "argilectx.arg"
void argile_puts(char * s)
/** :argile_puts <text s>: -> nothing **/
{
#line 1649 "argilectx.arg"
  if ((*&(s)[0] != 0)) {
#line 1649 "argilectx.arg"
    argile_output(s, strlen(s));
  } //;
}

#line 1656 "argilectx.arg"
void argile_putn(int n_2)
/** :argile_putn <int n>: -> nothing **/
{
#line 1657 "argilectx.arg"
  char( s_2[16]);

#line 1658 "argilectx.arg"
  n_2 = snprintf(((char *)s_2), sizeof(s_2), "%d", n_2);
  if (((n_2 > 0) && (n_2 < sizeof(s_2)))) {
    argile_output(((char *)s_2), n_2);
  } //;
}

#line 1667 "argilectx.arg"
void argile_indent()
/** :argile_indent: -> nothing **/
{
#line 1668 "argilectx.arg"
  int i_2 = 0;

#line 1669 "argilectx.arg"
  for (i_2 = 0; (i_2 < (argile).indent); (i_2)++) {
    argile_puts("  ");
  };
}

#line 1677 "argilectx.arg"
unsigned int argile_hash(char * t_3)
/** :argile_hash <text t>: -> nat **/
{
#line 1678 "argilectx.arg"
  unsigned int h = 0;

#line 1679 "argilectx.arg"
  while ((*&(t_3)[0] != 0)) {
    h += ((unsigned int)*&((t_3)++)[0]);
    h += (h << 10);
    h ^= (h >> 6);
  };
#line 1683 "argilectx.arg"
  h += (h << 3);
  h ^= (h >> 11);
  h += (h << 15);
  return h;
}

#line 1696 "argilectx.arg"
int argile_streq(void * a, void * b)
/** :argile_streq <any a> <any b>: -> int **/
{
#line 1697 "argilectx.arg"
  return ((int)(strcmp(((char *)a), ((char *)b)) == 0));
}

#line 1707 "argilectx.arg"
void argile_check_collisions(argile_buff_t * ident_buff)
/** :argile_check_collisions <buff ident_buff>: -> nothing **/
{
#line 1708 "argilectx.arg"
  int num = 2;
  int end_2 = 0;
  unsigned int id = 0;

#line 1709 "argilectx.arg"
  end_2 = id_end_num((ident_buff)->ptr, (ident_buff)->len, &num);
  id = (argile_hash((ident_buff)->ptr) % 1024);
  while ((argile_list_search(((argile).ids)[id], (ident_buff)->ptr, (void *)&argile_streq))) {
#line 1714 "argilectx.arg"
    (ident_buff)->len = ((unsigned int)end_2);
    argile_buff_putc(ident_buff, '_');
    argile_buff_putn(ident_buff, (num)++);
    argile_buff_putc(ident_buff, '\0');
    id = (argile_hash((ident_buff)->ptr) % 1024);
  };
#line 1719 "argilectx.arg"
  argile_list_prepend(&((argile).ids)[id], argile_list_new(argile_dbg_strdup((ident_buff)->ptr), (void *)&argile_dbg_free));
}

#line 1745 "argilectx.arg"
void argile_check_local_collisions(argile_buff_t * ident_buff_2, argile_code_t * code)
/** :argile_check_local_collisions <buff ident_buff> <argile code code>: -> nothing **/
{
#line 1746 "argilectx.arg"
  int min = -1;
#line 1746 "argilectx.arg"
  int max = 1;
  unsigned char found;

#line 1747 "argilectx.arg"
  found = 0;
  while ((code)) {
    argile_list_t * ld;

#line 1750 "argilectx.arg"
    for (ld = (code)->defs; (ld); ld = ((argile_list_t *)ld)->next) {
      argile_def_t * d = ((argile_def_t *)0);
#line 1753 "argilectx.arg"
      char * id = "";

#line 1751 "argilectx.arg"
      d = ((argile_def_t *)*((void * *)&((argile_list_t *)ld)->data.u_anything));
      if ((d)->locall) {
#line 464 "./argrt/std.argl"
        continue;
      } //;
#line 1753 "argilectx.arg"
      id = (d)->genid;
      if (((id == NULL) && ((d)->param != NULL))) {
        id = ((d)->param)->genid;
      } //;
#line 1756 "argilectx.arg"
      check_id_num(ident_buff_2, id, &found, &min, &max);
    };
#line 1757 "argilectx.arg"
    for (ld = (code)->special_ids; (ld); ld = ((argile_list_t *)ld)->next) {
      check_id_num(ident_buff_2, ((char *)*((void * *)&((argile_list_t *)ld)->data.u_anything)), &found, &min, &max);
    };
#line 1759 "argilectx.arg"
    for (ld = (code)->calls; (ld); ld = ((argile_list_t *)ld)->next) {
      check_call_id_num(((argile_call_t *)*((void * *)&((argile_list_t *)ld)->data.u_anything)), ident_buff_2, &found, &min, &max);
    };
#line 1761 "argilectx.arg"
    code = (code)->upper;
#line 1773 "argilectx.arg"
  };
#line 1783 "argilectx.arg"
  if (!(found)) {
    unsigned int h = 0;

#line 1784 "argilectx.arg"
    h = (argile_hash((ident_buff_2)->ptr) % 1024);
    if ((argile_list_search(((argile).ids)[h], (ident_buff_2)->ptr, (void *)&argile_streq))) {
      found = 1;
    } //;
  } //;
#line 1787 "argilectx.arg"
  if (found) {
    ((ident_buff_2)->len)--;
    argile_buff_putc(ident_buff_2, '_');
    if ((min > 2)) {
      argile_buff_putn(ident_buff_2, (min - 1));
    } //;
#line 1792 "argilectx.arg"
    else {
      argile_buff_putn(ident_buff_2, (max + 1));
    };
#line 1794 "argilectx.arg"
    argile_buff_putc(ident_buff_2, '\0');
  } //;
}

#line 1801 "argilectx.arg"
void argile_globally(argile_code_t * code_2)
/** :argile_globally <argile code code>: -> nothing **/
{
#line 1802 "argilectx.arg"
  argile_list_prepend(&(argile).globally, argile_list_new(code_2, ((argile_deleter_t)0)));
}

#line 1813 "argilectx.arg"
void argile_search_defs(char * pattern, void (* callback)(argile_def_t *))
/** :argile_search_defs <text pattern> <function (def) callback>: -> nothing **/
{
#line 1814 "argilectx.arg"
  char( is_op[32]);
#line 1826 "argilectx.arg"
  argile_list_t * syntax_2 = ((argile_list_t *)0);
#line 1828 "argilectx.arg"
  char * s_2 = "";

#line 1815 "argilectx.arg"
  memset(&is_op, 0, sizeof(*&is_op));
#line 1817 "argilectx.arg"
  *&(((char *)&is_op))[('!' >> 3)] |= (1 << ('!' & 7));
#line 1817 "argilectx.arg"
  *&(((char *)&is_op))[('#' >> 3)] |= (1 << ('#' & 7));
#line 1817 "argilectx.arg"
  *&(((char *)&is_op))[('$' >> 3)] |= (1 << ('$' & 7));
  *&(((char *)&is_op))[('%' >> 3)] |= (1 << ('%' & 7));
#line 1818 "argilectx.arg"
  *&(((char *)&is_op))[('&' >> 3)] |= (1 << ('&' & 7));
#line 1818 "argilectx.arg"
  *&(((char *)&is_op))[('\'' >> 3)] |= (1 << ('\'' & 7));
  *&(((char *)&is_op))[('*' >> 3)] |= (1 << ('*' & 7));
#line 1819 "argilectx.arg"
  *&(((char *)&is_op))[('+' >> 3)] |= (1 << ('+' & 7));
#line 1819 "argilectx.arg"
  *&(((char *)&is_op))[(',' >> 3)] |= (1 << (',' & 7));
  *&(((char *)&is_op))[('-' >> 3)] |= (1 << ('-' & 7));
#line 1820 "argilectx.arg"
  *&(((char *)&is_op))[('.' >> 3)] |= (1 << ('.' & 7));
#line 1820 "argilectx.arg"
  *&(((char *)&is_op))[('/' >> 3)] |= (1 << ('/' & 7));
  *&(((char *)&is_op))[('<' >> 3)] |= (1 << ('<' & 7));
#line 1821 "argilectx.arg"
  *&(((char *)&is_op))[('=' >> 3)] |= (1 << ('=' & 7));
#line 1821 "argilectx.arg"
  *&(((char *)&is_op))[('>' >> 3)] |= (1 << ('>' & 7));
  *&(((char *)&is_op))[('?' >> 3)] |= (1 << ('?' & 7));
#line 1822 "argilectx.arg"
  *&(((char *)&is_op))[('@' >> 3)] |= (1 << ('@' & 7));
#line 1822 "argilectx.arg"
  *&(((char *)&is_op))[('[' >> 3)] |= (1 << ('[' & 7));
  *&(((char *)&is_op))[('\\' >> 3)] |= (1 << ('\\' & 7));
#line 1823 "argilectx.arg"
  *&(((char *)&is_op))[(']' >> 3)] |= (1 << (']' & 7));
#line 1823 "argilectx.arg"
  *&(((char *)&is_op))[('^' >> 3)] |= (1 << ('^' & 7));
  *&(((char *)&is_op))[('`' >> 3)] |= (1 << ('`' & 7));
#line 1824 "argilectx.arg"
  *&(((char *)&is_op))[('|' >> 3)] |= (1 << ('|' & 7));
#line 1824 "argilectx.arg"
  *&(((char *)&is_op))[('~' >> 3)] |= (1 << ('~' & 7));
#line 1828 "argilectx.arg"
  s_2 = pattern;
  while ((*&(s_2)[0] != 0)) {
#line 1841 "argilectx.arg"
    char * start = "";

#line 1831 "argilectx.arg"
    while ((*&(s_2)[0] == ' ')) {
#line 481 "./argrt/std.argl"
      (s_2)++;
    };
#line 1834 "argilectx.arg"
    while (((*&(s_2)[0] != 0) && (((*&(((char *)&is_op))[(((unsigned char)*&(s_2)[0]) >> 3)] >> (((unsigned char)*&(s_2)[0]) & 7)) & 1) != 0))) {
      char * cpy = "";

#line 1835 "argilectx.arg"
      cpy = ((char *)argile_dbg_malloc(2));
      *&(cpy)[0] = *&(s_2)[0];
#line 1836 "argilectx.arg"
      *&(cpy)[1] = ((char)0);
      argile_list_append(&syntax_2, argile_list_new(argile_syntax_new(ARGILE_SYN_OP, cpy), (void *)&argile_syntax_del));
      (s_2)++;
    };
#line 1841 "argilectx.arg"
    start = s_2;
    while ((((*&(s_2)[0] != 0) && (*&(s_2)[0] != ' ')) && (((*&(((char *)&is_op))[(((unsigned char)*&(s_2)[0]) >> 3)] >> (((unsigned char)*&(s_2)[0]) & 7)) & 1) == 0))) {
#line 481 "./argrt/std.argl"
      (s_2)++;
    };
#line 1843 "argilectx.arg"
    if (s_2>start) {
      char * cpy = "";

#line 1844 "argilectx.arg"
      cpy = ((char *)argile_dbg_malloc((1 + ((s_2) - start))));
      memcpy(cpy, start, ((s_2) - start));
      *&(cpy)[((s_2) - start)] = '\0';
      argile_list_append(&syntax_2, argile_list_new(argile_syntax_new(ARGILE_SYN_WORD, cpy), (void *)&argile_syntax_del));
    } //;
  };
#line 1849 "argilectx.arg"
  syntax_2 = argile_list_start(syntax_2);
  search_in_with(syntax_2, (argile).main, callback);
  argile_list_del(syntax_2);
#line 1865 "argilectx.arg"
}

#line 1888 "argilectx.arg"
int argile_match_or_reject(argile_call_t * c, argile_match_t * m, argile_type_t t_4, char * error)
/** :argile_match_or_reject <call c> <match m> <argile type t> <text error>: -> int **/
{
  argile_type_t mt;

#line 1889 "argilectx.arg"
  if ((argile_match_type(m, t_4))) {
    return 0;
  } //;
#line 1891 "argilectx.arg"
  mt = argile_match_get_type(m);
  if (((m)->type == ARGILE_MATCH_SUBCALL)) {
    argile_call_t * s_2 = ((argile_call_t *)0);

#line 1893 "argilectx.arg"
    s_2 = ((m)->value).call;
    if (((s_2)->type == ARGILE_CALL_EXPLICIT)) {
      argile_call_uncompile_subcalls(s_2, 1);
      (s_2)->def = ((argile_def_t *)0);
      (s_2)->compiled = 0;
      if ((argile_call_compile_as(s_2, t_4))) {
        return 0;
      } //;
    } //;
  } //;
#line 1900 "argilectx.arg"
  argile_call_mismatch(c, t_4, mt, error);
  return 1;
}

#line 1911 "argilectx.arg"
int argile_split_ops(int ops_type, char * str_2, int len_4, char * * lval)
/** :argile_split_ops <int ops_type> <text str> <int len> <(text) & lval>: -> int **/
{
#line 1917 "argilectx.arg"
  unsigned char o;
#line 1917 "argilectx.arg"
  unsigned char w;
  unsigned int c_2 = 0;
#line 1918 "argilectx.arg"
  unsigned int n_2 = 1;
  int i_2 = 0;
#line 1919 "argilectx.arg"
  int li = 0;

#line 1913 "argilectx.arg"
  if (((argile).op_ranges == NULL)) {
    *lval = argile_dbg_strdup(str_2);
    argile_push_token(T_WORD);
    return argile_pop_token();
  } //;
#line 1917 "argilectx.arg"
  w = 0;
#line 1920 "argilectx.arg"
  for (i_2 = 0; ((i_2 < len_4) && (n_2 > 0)); i_2 += n_2) {
    if (((argile).encoding == NULL)) {
      c_2 = ((unsigned int)((unsigned char)*&(str_2)[i_2]));
    } //;
#line 1923 "argilectx.arg"
    else {
      c_2 = (*((argile).encoding)->charat)(((str_2) + i_2), (len_4 - i_2));
      n_2 = (*((argile).encoding)->charsize)(((str_2) + i_2), (len_4 - i_2));
    };
#line 1926 "argilectx.arg"
    o = (argile_is_operator(c_2));
    if (o) {
      if (w) {
        split_op(((str_2) + li), (i_2 - li), T_WORD);
      } //;
#line 1930 "argilectx.arg"
      split_op(((str_2) + i_2), ((int)n_2), ops_type);
      li = i_2;
    } //;
#line 1932 "argilectx.arg"
    else if (!(w)) {
      li = i_2;
    } //;
#line 1934 "argilectx.arg"
    w = !(o);
  };
#line 1935 "argilectx.arg"
  if (w) {
    split_op(((str_2) + li), (i_2 - li), T_WORD);
  } //;
#line 1945 "argilectx.arg"
  *lval = argile_pop_op();
  argile_push_token(argile_pop_optoken());
  return argile_pop_token();
}

#line 1956 "argilectx.arg"
int argile_is_operator(unsigned int ch)
/** :argile_is_operator <nat ch>: -> int **/
{
#line 1957 "argilectx.arg"
  argile_list_t * lr;

#line 1957 "argilectx.arg"
  lr = (argile).op_ranges;
  for (; (lr); lr = ((argile_list_t *)lr)->next) {
    unsigned int(* r);

#line 1959 "argilectx.arg"
    r = *((unsigned int(* *))&((argile_list_t *)lr)->data);
    if ((ch < (r)[0])) {
      return 0;
    } //;
#line 1962 "argilectx.arg"
    if ((ch <= (r)[1])) {
      return 1;
    } //;
  };
#line 1964 "argilectx.arg"
  return 0;
}

#line 1975 "argilectx.arg"
void argile_add_operators(unsigned int a_2, unsigned int b_2)
/** :argile_add_operators <nat a> <nat b>: -> nothing **/
{
#line 1976 "argilectx.arg"
  if ((b_2 == 0)) {
#line 464 "./argrt/std.argl"
    b_2 = a_2;
  } //;
#line 1977 "argilectx.arg"
  if ((b_2 < a_2)) {
    unsigned int c_2 = 0;

#line 1978 "argilectx.arg"
    c_2 = a_2;
    a_2 = b_2;
    b_2 = c_2;
  } //;
#line 1981 "argilectx.arg"
  if (((argile).op_ranges)) {
    unsigned int(* r);
    argile_list_t * lr;
#line 1983 "argilectx.arg"
    argile_list_t * nr;

#line 1984 "argilectx.arg"
    for (lr = (argile).op_ranges; (lr); lr = nr) {
      r = *((unsigned int(* *))&((argile_list_t *)lr)->data);
      nr = ((argile_list_t *)lr)->next;
      if ((a_2 < (r)[0])) {
        if ((((r)[0] != 0) && (b_2 < ((r)[0] - 1)))) {
          argile_list_t * lnu;

#line 1989 "argilectx.arg"
          lnu = new_range(a_2, b_2);
          if ((((argile_list_t *)lr)->prev)) {
            argile_list_link(((argile_list_t *)lr)->prev, lnu);
          } //;
#line 1992 "argilectx.arg"
          else {
            (argile).op_ranges = lnu;
          };
#line 1994 "argilectx.arg"
          argile_list_link(lnu, lr);
          break;
        } //;
#line 1996 "argilectx.arg"
        *&(r)[0] = a_2;
        if ((b_2 <= (r)[1])) {
#line 464 "./argrt/std.argl"
          break;
        } //;
#line 1998 "argilectx.arg"
        *&(r)[1] = b_2;
        if ((nr == NULL)) {
#line 464 "./argrt/std.argl"
          break;
        } //;
#line 2000 "argilectx.arg"
        argile_list_rm(&(argile).op_ranges, lr);
        argile_list_del(lr);
      } //;
#line 2002 "argilectx.arg"
      else if ((a_2 <= ((r)[1] + 1))) {
        if ((b_2 <= (r)[1])) {
#line 464 "./argrt/std.argl"
          break;
        } //;
#line 2004 "argilectx.arg"
        *&(r)[1] = b_2;
        if ((nr == NULL)) {
#line 464 "./argrt/std.argl"
          break;
        } //;
#line 2006 "argilectx.arg"
        a_2 = (r)[0];
        argile_list_rm(&(argile).op_ranges, lr);
        argile_list_del(lr);
      } //;
    };
#line 2009 "argilectx.arg"
    if (((lr == NULL) && (a_2 > (r)[1]))) {
      argile_list_link(argile_list_end((argile).op_ranges), new_range(a_2, b_2));
    } //;
  } //;
#line 2011 "argilectx.arg"
  else {
    (argile).op_ranges = new_range(a_2, b_2);
  };
#line 2013 "argilectx.arg"
}

#line 2029 "argilectx.arg"
argile_def_t * argile_find_def(char * mod_2, char * bnd, char * opt_2, int err)
/** :argile_find_def <text mod> <text bnd> <text opt> <int err>: -> (argile) def **/
{
#line 2030 "argilectx.arg"
  argile_module_t * m_2 = ((argile_module_t *)0);
#line 2035 "argilectx.arg"
  argile_bind_t * b_2 = ((argile_bind_t *)0);
#line 2040 "argilectx.arg"
  unsigned char o;
  argile_code_t * c_2 = ((argile_code_t *)0);

#line 2030 "argilectx.arg"
  m_2 = argile_getmod(mod_2);
  if ((m_2 == NULL)) {
    if ((err != 0)) {
      argile_die("module '%s' not found", mod_2);
    } //;
#line 2034 "argilectx.arg"
    return ((argile_def_t *)0);
  } //;
#line 2035 "argilectx.arg"
  b_2 = argile_module_getbind(m_2, bnd);
  if ((b_2 == NULL)) {
    if ((err)) {
      argile_die("binding '%s' not found in module '%s'", bnd, mod_2);
    } //;
#line 2039 "argilectx.arg"
    return ((argile_def_t *)0);
  } //;
#line 2040 "argilectx.arg"
  o = 0;
#line 2042 "argilectx.arg"
  for (c_2 = (argile).main; (c_2); c_2 = (c_2)->upper) {
    argile_list_t * ld;

#line 2043 "argilectx.arg"
    ld = (c_2)->defs;
    for (; (ld); ld = ((argile_list_t *)ld)->next) {
      argile_def_t * d = ((argile_def_t *)0);

#line 2045 "argilectx.arg"
      d = *((argile_def_t * *)&((argile_list_t *)ld)->data);
      if ((((d)->dtype == ARGILE_DEF_BIND) && (((d)->dval).bind == b_2))) {
        if ((((opt_2 == NULL) || (*&(opt_2)[0] == 0)) || (argile_def_has_option(d, opt_2)))) {
          return d;
        } //;
#line 2049 "argilectx.arg"
        o = 1;
      } //;
    };
  };
#line 2050 "argilectx.arg"
  if ((err)) {
    if (o) {
      argile_die("binding '%s' in module '%s' not defined with option '%s'\n  (did you forget to use std ?)", bnd, mod_2, opt_2);
    } //;
#line 2055 "argilectx.arg"
    else {
      argile_die("binding '%s' in module '%s' found, but not defined", bnd, mod_2);
    };
  } //;
#line 2057 "argilectx.arg"
  return ((argile_def_t *)0);
}

#line 2063 "argilectx.arg"
void argile_add_gstats()
/** :argile_add_gstats: -> nothing **/
{
#line 2064 "argilectx.arg"
  ((argile).gstat).rejsize += ((argile).stat).rejsize;
  ((argile).gstat).rejmaxsize += ((argile).stat).rejmaxsize;
  ((argile).gstat).hitsize += ((argile).stat).hitsize;
  ((argile).gstat).num_match_eq += ((argile).stat).num_match_eq;
  ((argile).gstat).num_match_try += ((argile).stat).num_match_try;
  ((argile).gstat).num_call_compile_as += ((argile).stat).num_call_compile_as;
  ((argile).gstat).vars += ((argile).stat).vars;
  ((argile).gstat).params += ((argile).stat).params;
  ((argile).gstat).funcs += ((argile).stat).funcs;
  ((argile).gstat).macros += ((argile).stat).macros;
  ((argile).gstat).binds += ((argile).stat).binds;
}

#line 281 "argilectx.arg"
static unsigned char is_not_included(argile_code_t * c_2)
/** :<argile code c> is not included: -> bool **/
{
#line 282 "argilectx.arg"
  argile_list_t * cur;

#line 282 "argilectx.arg"
  for (cur = (argile).used; (cur); cur = ((argile_list_t *)cur)->next) {
    if (((*((argile_file_t * *)&((argile_list_t *)cur)->data))->code == c_2)) {
#line 464 "./argrt/std.argl"
      return 0;
    } //;
  };
#line 284 "argilectx.arg"
  return 1;
}

#line 380 "argilectx.arg"
static unsigned char argile_pos_su_argile_pos(argile_pos_t * a_3, argile_pos_t * b_3)
/** :<pos a> > <pos b>: -> bool **/
{
#line 381 "argilectx.arg"
  if (((a_3)->row == (b_3)->row)) {
    return ((a_3)->col > (b_3)->col);
  } //;
#line 383 "argilectx.arg"
  return ((a_3)->row > (b_3)->row);
}

#line 418 "argilectx.arg"
static void comment(comment_t * c_3)
/** :<comment c>: -> nothing **/
{
#line 419 "argilectx.arg"
  if (((c_3)->txt)) {
#line 464 "./argrt/std.argl"
    argile_dbg_free((c_3)->txt);
  } //;
#line 420 "argilectx.arg"
  argile_dbg_free(c_3);
}

#line 533 "argilectx.arg"
static void print_define(char * * name, int * size, argile_file_t * * file)
/** :print define: -> nothing **/
{
#line 534 "argilectx.arg"
  argile_output("_", 1);
  argile_output(*name, *size);
  argile_puts("_HEADER_");
  if ((*file)) {
    argile_printf("_device_%ld_inode_%li_", ((long)(*file)->device), ((long)(*file)->inode));
  } //;
}

#line 504 "argilectx.arg"
static int get_word_size_of(char * t_5)
/** :get word size of <text t>: -> int **/
{
#line 505 "argilectx.arg"
  int size_2 = 0;

#line 506 "argilectx.arg"
  while ((((((*&(t_5)[0] >= 'a') && (*&(t_5)[0] <= 'z')) || ((*&(t_5)[0] >= 'A') && (*&(t_5)[0] <= 'Z'))) || ((*&(t_5)[0] >= '0') && (*&(t_5)[0] <= '9'))) || (*&(t_5)[0] == '_'))) {
#line 510 "argilectx.arg"
    (size_2)++;
#line 510 "argilectx.arg"
    (t_5)++;
  };
#line 511 "argilectx.arg"
  return size_2;
}

#line 992 "argilectx.arg"
static void write_ref_or_raw_in_with(argile_buff_t * tb, argile_buff_t * out_3, argile_def_t * d, char * name_5)
/** :write ref or raw <buff tb> in <buff out> with <def d> <text name>: -> nothing **/
{
#line 993 "argilectx.arg"
  if ((d)) {
    argile_syntax_module_call((d)->syntax, tb, (char *)0, ((argile_list_t *)0), out_3);
  } //;
#line 995 "argilectx.arg"
  else {
    argile_buff_puts(out_3, name_5);
    argile_buff_puts(out_3, " to (");
    argile_buff_cat(out_3, tb);
    argile_buff_putc(out_3, *&(")")[0]);
  };
}

#line 1147 "argilectx.arg"
static void add_include(char * p)
/** :add include <text p>: -> nothing **/
{
#line 1148 "argilectx.arg"
  int n_2 = 0;
  char * h = "";
#line 1151 "argilectx.arg"
  int e = 0;

#line 1148 "argilectx.arg"
  n_2 = strlen(p);
  h = ((char *)argile_dbg_malloc((n_2 + 3)));
  memcpy(h, p, n_2);
#line 1152 "argilectx.arg"
  if (((e = ends_by(p, n_2, ".arg")) || (e = ends_by(p, n_2, ".argl")))) {
#line 1154 "argilectx.arg"
    memcpy(((((h) + n_2)) - e), ".h", 3);
  } //;
#line 1155 "argilectx.arg"
  else {
    memcpy(((h) + n_2), ".h", 3);
  };
#line 1157 "argilectx.arg"
  if ((argile_list_search((argile).includes, h, (void *)&argile_streq))) {
    argile_dbg_free(h);
  } //;
#line 1159 "argilectx.arg"
  else {
    argile_list_prepend(&(argile).includes, argile_list_new(h, (void *)&argile_dbg_free));
  };
}

#line 1212 "argilectx.arg"
static argile_file_t * try_in_dir(char * path_3, int plen, char * dir, int dlen)
/** :try <text path> <int plen> in dir <text dir> <int dlen>: -> (argile) file **/
{
#line 1213 "argilectx.arg"
  int trysize = 0;
  char * trypath = "";
#line 1218 "argilectx.arg"
  int end_2 = 0;
  struct stat st;

#line 1213 "argilectx.arg"
  trysize = ((dlen + 1) + plen);
  trypath = ((char *)argile_dbg_malloc(trysize));
  memcpy(trypath, dir, dlen);
  snprintf(((trypath) + dlen), (trysize - dlen), "/%s", path_3);
  strip_useless_slashes_in(trypath);
  end_2 = strlen(trypath);
#line 1220 "argilectx.arg"
  if (doesn_t_end_by_ext(path_3)) {
    snprintf(((trypath) + end_2), (trysize - end_2), "%s", ".argl");
    if (!((stat(trypath, &st)))) {
      argile_file_t * file_2 = ((argile_file_t *)0);
#line 1225 "argilectx.arg"
      time_t time = st.st_mtime;

#line 1223 "argilectx.arg"
      file_2 = argile_file_new(trypath, &st);
#line 1226 "argilectx.arg"
      snprintf(((trypath) + end_2), (trysize - end_2), "%s", ".arg");
      if (!((stat(trypath, &st)))) {
        argile_file_t * srcfile = ((argile_file_t *)0);

#line 1228 "argilectx.arg"
        srcfile = argile_file_new(trypath, &st);
        if (time<st.st_mtime) {
          if (!((argile_list_search((argile).warns, (file_2)->path, (void *)&argile_streq)))) {
            argile_list_prepend(&(argile).warns, argile_list_new(argile_dbg_strdup((file_2)->path), (void *)&argile_dbg_free));
            fprintf(stderr, "%s: warning: %s is ignored (older than %s)\n", "arc", (file_2)->path, trypath);
          } //;
          argile_file_del(file_2);
          argile_dbg_free(trypath);
          return srcfile;
        } //;
#line 1237 "argilectx.arg"
        if ((argile_file_eq(srcfile, (argile).main_file))) {
          argile_file_del(file_2);
          argile_dbg_free(trypath);
          return srcfile;
        } //;
        argile_file_del(srcfile);
        (file_2)->derived = 1;
      } //;
#line 1244 "argilectx.arg"
      argile_dbg_free(trypath);
      return file_2;
    } //;
    snprintf(((trypath) + end_2), (trysize - end_2), "%s", ".arg");
    if (!((stat(trypath, &st)))) {
      argile_file_t * file_2 = ((argile_file_t *)0);

#line 1249 "argilectx.arg"
      file_2 = argile_file_new(trypath, &st);
      argile_dbg_free(trypath);
      return file_2;
    } //;
  } //;
#line 1252 "argilectx.arg"
  *&(trypath)[end_2] = '\0';
  if (!((stat(trypath, &st)))) {
    argile_file_t * file_2 = ((argile_file_t *)0);

#line 1254 "argilectx.arg"
    file_2 = argile_file_new(trypath, &st);
    argile_dbg_free(trypath);
    return file_2;
  } //;
#line 1257 "argilectx.arg"
  argile_dbg_free(trypath);
#line 1286 "argilectx.arg"
  return ((argile_file_t *)0);
}

#line 1258 "argilectx.arg"
static void strip_useless_slashes_in(char * s_2)
/** :strip useless slashes in <text s>: -> nothing **/
{
#line 1259 "argilectx.arg"
  while ((*&(s_2)[0] != 0)) {
    if ((*&(s_2)[0] == '/')) {
      int x = 0;

#line 1262 "argilectx.arg"
      if (!((strncmp(((s_2) + 1), "./", 2)))) {
        x = 3;
        while (!((strncmp(((s_2) + x), "./", 2)))) {
          x += 2;
        };
#line 1266 "argilectx.arg"
        reduce(((s_2) + 1), ((s_2) + x));
      } //;
#line 1267 "argilectx.arg"
      else {
        x = 1;
        while ((*&(s_2)[x] == '/')) {
          (x)++;
        };
#line 1271 "argilectx.arg"
        reduce(((s_2) + 1), ((s_2) + x));
      };
#line 1272 "argilectx.arg"
    } //;
#line 1276 "argilectx.arg"
    (s_2)++;
  };
}

#line 1277 "argilectx.arg"
static unsigned char doesn_t_end_by_ext(char * str_3)
/** :<text str> doesn ' t end by ext: -> bool **/
{
#line 1278 "argilectx.arg"
  int elen = 0;
  int llen = 0;
  int slen = 0;

#line 1278 "argilectx.arg"
  elen = strlen(".arg");
  llen = strlen(".argl");
  slen = strlen(str_3);
  if (((slen > elen) && (strcmp(".arg", ((str_3) + (slen - elen))) == 0))) {
    return 0;
  } //;
#line 1283 "argilectx.arg"
  if (((slen > llen) && (strcmp(".argl", ((str_3) + (slen - llen))) == 0))) {
    return 0;
  } //;
#line 1285 "argilectx.arg"
  return 1;
}

#line 1272 "argilectx.arg"
static void reduce(char * d_2, char * s_3)
/** :reduce <text d> <text s>: -> nothing **/
{
#line 1273 "argilectx.arg"
  while ((*&(s_3)[0] != 0)) {
    *&((d_2)++)[0] = *&((s_3)++)[0];
  };
#line 1275 "argilectx.arg"
  *&(d_2)[0] = *&(s_3)[0];
}

#line 1720 "argilectx.arg"
static int id_end_num(char * s_4, unsigned int n_3, int * num_2)
/** :id end num <text s> <nat n> <(int) & num>: -> int **/
{
#line 1722 "argilectx.arg"
  int i_2 = 0;
#line 1722 "argilectx.arg"
  int u = -1;
  char c_2;

#line 1724 "argilectx.arg"
  for (i_2 = 0; (i_2 < n_3); (i_2)++) {
    if ((*&(s_4)[i_2] == '_')) {
      u = i_2;
    } //;
  };
#line 1727 "argilectx.arg"
  if (((u <= 0) || (*&(s_4)[(u + 1)] == 0))) {
    return (n_3 - 1);
  } //;
#line 1729 "argilectx.arg"
  for (i_2 = (u + 1); (c_2 = *&(s_4)[i_2]); (i_2)++) {
    if (((c_2 < '0') || (c_2 > '9'))) {
      return (n_3 - 1);
    } //;
  };
#line 1732 "argilectx.arg"
  *num_2 = atoi(((s_4) + (u + 1)));
  return u;
}

#line 1762 "argilectx.arg"
static void check_id_num(argile_buff_t * b_4, char * id, unsigned char * found_2, int * min_2, int * max_2)
/** :check id num <buff b> <text id> <(bool) & found> <(int) & min> <(int) & max>: -> nothing **/
{
#line 1763 "argilectx.arg"
  int i_2 = 0;

#line 1763 "argilectx.arg"
  i_2 = ((b_4)->len - 1);
  if (((id) && !((strncmp(id, (b_4)->ptr, i_2))))) {
    if ((*&(id)[i_2] == 0)) {
      *found_2 = 1;
    } //;
#line 1767 "argilectx.arg"
    else if ((*&(id)[i_2] == '_')) {
      do {
#line 1768 "argilectx.arg"
        (i_2)++;
      } while (((*&(id)[i_2] >= '0') && (*&(id)[i_2] <= '9')));
#line 1769 "argilectx.arg"
      if ((*&(id)[i_2] == 0)) {
        i_2 = atoi(((id) + (b_4)->len));
        if ((i_2 > *max_2)) {
#line 1771 "argilectx.arg"
          *max_2 = i_2;
        } //;
#line 1772 "argilectx.arg"
        if (((*min_2 < 0) || (i_2 < *min_2))) {
#line 1772 "argilectx.arg"
          *min_2 = i_2;
        } //;
      } //;
    } //;
  } //;
}

#line 1773 "argilectx.arg"
static void check_call_id_num(argile_call_t * p_argile_call, argile_buff_t * b_5, unsigned char * found_3, int * min_3, int * max_3)
/** :check call id num <call> <buff b> <(bool) & found> <(int) & min> <(int) & max>: -> nothing **/
{
#line 1774 "argilectx.arg"
  argile_list_t * lm;

#line 1774 "argilectx.arg"
  for (lm = (p_argile_call)->match; (lm); lm = ((argile_list_t *)lm)->next) {
    argile_match_t * m_2 = ((argile_match_t *)0);

#line 1775 "argilectx.arg"
    m_2 = ((argile_match_t *)*((void * *)&((argile_list_t *)lm)->data.u_anything));
    if ((m_2 == NULL)) {
#line 464 "./argrt/std.argl"
      continue;
    } //;
#line 1777 "argilectx.arg"
    if (((m_2)->type == ARGILE_MATCH_SUBCALL)) {
      check_call_id_num(((m_2)->value).call, b_5, found_3, min_3, max_3);
    } //;
#line 1779 "argilectx.arg"
    else if (((m_2)->type == ARGILE_MATCH_CONS)) {
      argile_cons_t * cons = ((argile_cons_t *)0);

#line 1780 "argilectx.arg"
      cons = ((m_2)->value).cons;
      if (((cons)->ctype == ARGILE_CONS_CODE)) {
        check_id_num(b_5, (((cons)->cvalue).code)->anon, found_3, min_3, max_3);
      } //;
    } //;
  };
}

#line 1853 "argilectx.arg"
static void search_in_with(argile_list_t * syn, argile_code_t * code_3, void (* callback_2)(argile_def_t *))
/** :search <list of (argile syntax) syn> in <argile code code> with <function (def) callback>: -> nothing **/
{
  argile_list_t * ld;
#line 1862 "argilectx.arg"
  argile_list_t * lc;

#line 1856 "argilectx.arg"
  ld = (code_3)->defs;
  for (; (ld); ld = ((argile_list_t *)ld)->next) {
    argile_def_t * d_2 = ((argile_def_t *)0);

#line 1858 "argilectx.arg"
    d_2 = *((argile_def_t * *)&((argile_list_t *)ld)->data);
    if (((d_2)->maker == NULL)) {
#line 464 "./argrt/std.argl"
      continue;
    } //;
#line 1860 "argilectx.arg"
    if ((argile_syntax_match((d_2)->syntax, syn))) {
      (*callback_2)(d_2);
    } //;
  };
#line 1862 "argilectx.arg"
  lc = (code_3)->calls;
  for (; (lc); lc = ((argile_list_t *)lc)->next) {
    search_in_with_2(syn, *((argile_call_t * *)&((argile_list_t *)lc)->data), callback_2);
  };
}

#line 1865 "argilectx.arg"
static void search_in_with_2(argile_list_t * syn_2, argile_call_t * p_argile_call_2, void (* callback_3)(argile_def_t *))
/** :search <list of (argile syntax) syn> in <call> with <function (def) callback>: -> nothing **/
{
  argile_list_t * lm;

#line 1868 "argilectx.arg"
  lm = (p_argile_call_2)->match;
  for (; (lm); lm = ((argile_list_t *)lm)->next) {
    argile_match_t * m_2 = ((argile_match_t *)0);

#line 1870 "argilectx.arg"
    m_2 = *((argile_match_t * *)&((argile_list_t *)lm)->data);
    if ((m_2 == NULL)) {
#line 464 "./argrt/std.argl"
      continue;
    } //;
#line 1872 "argilectx.arg"
    if (((m_2)->type == ARGILE_MATCH_SUBCALL)) {
      search_in_with_2(syn_2, ((m_2)->value).call, callback_3);
    } //;
#line 1874 "argilectx.arg"
    else if ((((m_2)->type == ARGILE_MATCH_CONS) && ((((m_2)->value).cons)->ctype == ARGILE_CONS_CODE))) {
#line 1876 "argilectx.arg"
      search_in_with(syn_2, ((((m_2)->value).cons)->cvalue).code, callback_3);
    } //;
  };
}

#line 1937 "argilectx.arg"
static void split_op(char * str_4, int len_5, int optoken)
/** :split op <text str> <int len> <int optoken>: -> nothing **/
{
#line 1938 "argilectx.arg"
  char * cpy = "";

#line 1938 "argilectx.arg"
  cpy = ((char *)argile_dbg_malloc((len_5 + 1)));
  argile_add_leak(cpy);
  memcpy(cpy, str_4, len_5);
  *&(cpy)[len_5] = '\0';
  argile_push_op(cpy);
  argile_push_optoken(optoken);
}

#line 2013 "argilectx.arg"
static argile_list_t * new_range(unsigned int a_4, unsigned int b_6)
/** :new range <nat a> <nat b>: -> list of (array of (nat)) **/
{
#line 2014 "argilectx.arg"
  unsigned int(* r);

#line 2014 "argilectx.arg"
  r = ((unsigned int(*))argile_dbg_malloc((2 * sizeof(unsigned int))));
  *&(r)[0] = a_4;
  *&(r)[1] = b_6;
  return argile_list_new(r, (void *)&argile_dbg_free);
}

