// generated by: arc -uRNMLP -o regex.c -H regex.h -m regex.argl regex.arg 
#include "regex.h"

#line 42 "regex.arg"
static void init_regex();
/** :init regex: -> nothing **/
#line 61 "regex.arg"
static void update_reggroups();
/** :update reggroups: -> nothing **/
#line 206 "regex.arg"
static regex_t* compile(char *, char *);
/** :compile <text re> <text opts>: -> (regex) * **/
#line 45 "regex.arg"
static void * anonymous_45_45_(void *anon_arg, ...);
#line 127 "regex.arg"
static void do_replace(char * * t, int * bylen, void *(* * realloc)(void *, ...), char * * by, int, int);
/** :do replace <int start> <int end>: -> nothing **/
#line 114 "regex.arg"
static void * anything_nat(void *, unsigned int);
/** :<any p> <nat n>: -> anything **/
#line 150 "regex.arg"
static unsigned char expand(char * * by, char * * t, int * bylen, int);
/** :expand <int off>: -> bool **/

#line 40 "regex.arg"
char * _ = "";

#line 34 "regex.arg"
static unsigned char regex_inited = 0;
static c_hash_t * regexps;
#line 37 "regex.arg"
static regmatch_t( matches[10]);
static char *( groups[10]);

#line 42 "regex.arg"
static void init_regex()
/** :init regex: -> nothing **/
{
#line 43 "regex.arg"
  if (regex_inited) {
#line 464 "./std.argl"
    return;
  } //;
#line 44 "regex.arg"
  regexps = ((c_hash_t *)new_hash(512, 1));
  ((c_hash_t *)regexps)->del = (void *)&anonymous_45_45_;
  memset(groups, 0, sizeof(groups));
  regex_inited = 1;
}

#line 49 "regex.arg"
void uninit_regex()
/** :uninit regex: -> nothing **/
{
#line 53 "regex.arg"
  int i = 0;

#line 50 "regex.arg"
  if (!(regex_inited)) {
#line 464 "./std.argl"
    return;
  } //;
#line 51 "regex.arg"
  del_hash(regexps);
  regexps = ((c_hash_t *)0);
  while ((i < 10)) {
#line 53 "regex.arg"
    if (!(((groups)[i] == NULL))) {
#line 464 "./std.argl"
      dbg_free((groups)[i]);
    } //;
#line 53 "regex.arg"
    (i)++;
  };
#line 54 "regex.arg"
  regex_inited = 0;
}

#line 56 "regex.arg"
char * reggroup(unsigned int n, ...)
/** :{reggroup | $} <nat n>: -> text **/
{
#line 57 "regex.arg"
  if (!(regex_inited)) {
#line 464 "./std.argl"
    init_regex();
  } //;
#line 58 "regex.arg"
  if (((n >= 10) || ((groups)[n] == NULL))) {
#line 464 "./std.argl"
    return "";
  } //;
#line 59 "regex.arg"
  return (groups)[n];
}

#line 61 "regex.arg"
static void update_reggroups()
/** :update reggroups: -> nothing **/
{
#line 62 "regex.arg"
  unsigned int n_2 = 0;

#line 62 "regex.arg"
  for (n_2 = 0; ((n_2 <= (10 - 1))); (n_2)++) {
    int so = 0;
    int eo = 0;
    char * g = "";
    int len = 0;

#line 63 "regex.arg"
    so = (matches)[n_2].rm_so;
    eo = (matches)[n_2].rm_eo;
    g = (groups)[n_2];
    len = strlen(_);
    if (((((so == -1) || (eo == -1)) || (so == eo)) || (so >= len))) {
      g = ((char *)dbg_realloc(g, 1));
      *&(g)[0] = ((char)0);
      *&(groups)[n_2] = g;
      continue;
    } //;
#line 72 "regex.arg"
    if ((eo > len)) {
#line 464 "./std.argl"
      eo = len;
    } //;
#line 73 "regex.arg"
    len = (eo - so);
    g = ((char *)dbg_realloc((groups)[n_2], (len + 1)));
    memcpy(g, ((_) + so), len);
    *&(g)[len] = ((char)0);
    *&(groups)[n_2] = g;
  };
}

#line 86 "regex.arg"
unsigned char matches_2(char * t_2, char * re, char * opts, unsigned char again, ...)
/** :<text t> matches / <text re> / (<text opts>) (<bool again>): -> bool **/
{
  unsigned int len = 0;
  char * key = "";
#line 92 "regex.arg"
  regex_t* cre;
#line 103 "regex.arg"
  int eflags = 0;
#line 107 "regex.arg"
  unsigned char r;

#line 87 "regex.arg"
  if (!(regex_inited)) {
#line 464 "./std.argl"
    init_regex();
  } //;
#line 88 "regex.arg"
  _ = t_2;
  len = ((strlen(opts) + strlen(re)) + 2);
  key = ((char *)dbg_malloc(len));
  snprintf(key, len, "%s/%s", re, opts);
  cre = ((regex_t*)c_hash_os_text_cs_2((c_hash_t *)regexps, key));
  if (((cre != NULL) && (strchr(opts, 'r')))) {
    (*((c_hash_t *)regexps)->del)(cre);
    cre = ((regex_t*)0);
  } //;
#line 96 "regex.arg"
  if ((cre == NULL)) {
    cre = compile(re, opts);
    if ((cre == NULL)) {
      dbg_free(key);
      return 0;
    } //;
#line 101 "regex.arg"
    *((regex_t* *)c_hash_os_text_cs((c_hash_t *)regexps, key)) = cre;
  } //;
#line 102 "regex.arg"
  dbg_free(key);
#line 104 "regex.arg"
  if (again) {
    eflags = (REG_NOTBOL | REG_NOTEOL);
  } //;
  r = !(((unsigned char)regexec(cre, t_2, 10, matches, eflags)));
  if (r) {
    update_reggroups();
  } //;
#line 110 "regex.arg"
  return r;
}

#line 112 "regex.arg"
int replace_in_realloc(char * * t, char * pattern, char * by, char * opts_2, void *(* realloc)(void *, ...), ...)
/** :replace in <(text) & t> / <text pattern> / <text by> / (<text opts>) (realloc = <code realloc>): -> int **/
{
  int count_2 = 0;
#line 115 "regex.arg"
  int bylen = 0;

#line 114 "regex.arg"
  if ((realloc == NULL)) {
#line 114 "regex.arg"
    realloc = (void *(*)(void *, ...))&anything_nat;
  } //;
#line 115 "regex.arg"
  bylen = strlen(by);
  if ((strchr(opts_2, 'g'))) {
    int off = 0;

#line 118 "regex.arg"
    while (matches_2(((*t) + off), pattern, opts_2, (count_2 != 0))) {
      (count_2)++;
      do_replace(t, &bylen, &realloc, &by, ((matches)[0].rm_so + off), ((matches)[0].rm_eo + off));
      off += ((matches)[0].rm_so + bylen);
      if ((*&(*t)[off] == 0)) {
#line 464 "./std.argl"
        break;
      } //;
#line 123 "regex.arg"
      if (((matches)[0].rm_so == (matches)[0].rm_eo)) {
#line 464 "./std.argl"
        (off)++;
      } //;
    };
  } else if (matches_2(*t, pattern, opts_2, ((unsigned char)0))) {
#line 125 "regex.arg"
    count_2 = 1;
    do_replace(t, &bylen, &realloc, &by, (matches)[0].rm_so, (matches)[0].rm_eo);
  } //;
#line 204 "regex.arg"
  return count_2;
}

#line 206 "regex.arg"
static regex_t* compile(char * re_2, char * opts_3)
/** :compile <text re> <text opts>: -> (regex) * **/
{
#line 207 "regex.arg"
  regex_t* r;
#line 209 "regex.arg"
  int cflags = 0;
#line 216 "regex.arg"
  int er = 0;

#line 207 "regex.arg"
  r = ((regex_t*)dbg_malloc(sizeof(regex_t)));
  memset(r, 0, sizeof(*r));
#line 210 "regex.arg"
  if (!((strchr(opts_3, 'b')))) {
    cflags |= REG_EXTENDED;
  } //;
#line 212 "regex.arg"
  if ((strchr(opts_3, 'i'))) {
    cflags |= REG_ICASE;
  } //;
#line 214 "regex.arg"
  if ((strchr(opts_3, 'n'))) {
    cflags |= REG_NEWLINE;
  } //;
#line 216 "regex.arg"
  er = ((int)regcomp(r, re_2, cflags));
  if ((er != 0)) {
    char( buf[256]);

#line 219 "regex.arg"
    regerror(er, r, buf, sizeof(buf));
    fprintf(stderr, "regular expression : %s : %s\n", re_2, buf);
    regfree(r);
    dbg_free(r);
    return ((regex_t*)0);
  } //;
#line 224 "regex.arg"
  return r;
}

#line 45 "regex.arg"
static void * anonymous_45_45_(void *anon_arg, ...)
{
  va_list anon_va;
  va_start(anon_va, anon_arg);

#line 45 "regex.arg"
  regfree(anon_arg);
#line 45 "regex.arg"
  dbg_free(anon_arg);
  va_end(anon_va);
  return NULL;
}

#line 127 "regex.arg"
static void do_replace(char * * t, int * bylen, void *(* * realloc)(void *, ...), char * * by, int start, int end)
/** :do replace <int start> <int end>: -> nothing **/
{
#line 128 "regex.arg"
  int remove = 0;
  int len = 0;
  unsigned char must_free;

#line 128 "regex.arg"
  remove = (end - start);
  len = strlen(*t);
  must_free = expand(by, t, bylen, (start - (matches)[0].rm_so));
  if ((*bylen > remove)) {
    int add = 0;
#line 136 "regex.arg"
    int i = 0;

#line 132 "regex.arg"
    add = (*bylen - remove);
#line 134 "regex.arg"
    *t = ((char *)(**realloc)(*t, (len + (1 + add))));
#line 137 "regex.arg"
    for (i = len; (i >= end); (i)--) {
      *&(*t)[(i + add)] = *&(*t)[i];
    };
  } else {
#line 140 "regex.arg"
    int sub = 0;

#line 140 "regex.arg"
    sub = (remove - *bylen);
    if ((sub > 0)) {
#line 143 "regex.arg"
      int i = 0;

#line 144 "regex.arg"
      for (i = end; (i <= len); (i)++) {
        *&(*t)[(i - sub)] = *&(*t)[i];
      };
      *t = ((char *)(**realloc)(*t, (len + (1 - sub))));
    } //;
  };
#line 148 "regex.arg"
  memcpy(((*t) + start), *by, *bylen);
  if (must_free) {
#line 464 "./std.argl"
    dbg_free(*by);
  } //;
#line 150 "regex.arg"
}

#line 114 "regex.arg"
static void * anything_nat(void * p, unsigned int n_2)
/** :<any p> <nat n>: -> anything **/
{
#line 114 "regex.arg"
  return dbg_realloc(p, n_2);
}

#line 150 "regex.arg"
static unsigned char expand(char * * by, char * * t, int * bylen, int off)
/** :expand <int off>: -> bool **/
{
#line 152 "regex.arg"
  int i = 0;
#line 152 "regex.arg"
  int len_2 = 0;
#line 152 "regex.arg"
  int refs = 0;
#line 152 "regex.arg"
  int escs = 0;
  unsigned char esc;
#line 176 "regex.arg"
  char * tmp = "";

#line 153 "regex.arg"
  esc = 0;
  while ((*&(*by)[i] != 0)) {
    if (esc) {
      esc = 0;
      (escs)++;
      (len_2)++;
#line 158 "regex.arg"
      (i)++;
#line 158 "regex.arg"
      continue;
    } //;
#line 159 "regex.arg"
    if ((*&(*by)[i] == '\\')) {
      int n_2 = 0;

#line 160 "regex.arg"
      n_2 = (*&(*by)[(i + 1)] - '0');
      if (((n_2 >= 0) && (n_2 < 10))) {
        int add = 0;

#line 162 "regex.arg"
        add = ((matches)[n_2].rm_eo - (matches)[n_2].rm_so);
        if ((add > 0)) {
#line 464 "./std.argl"
          len_2 += add;
        } //;
#line 164 "regex.arg"
        (refs)++;
        (i)++;
      } else {
        esc = 1;
      };
    } else {
#line 169 "regex.arg"
      (len_2)++;
    };
#line 170 "regex.arg"
    (i)++;
  };
#line 171 "regex.arg"
  if (esc) {
    (len_2)++;
  } //;
#line 173 "regex.arg"
  if (((refs == 0) && (escs == 0))) {
#line 464 "./std.argl"
    return 0;
  } //;
#line 176 "regex.arg"
  tmp = ((char *)dbg_malloc((len_2 + 1)));
  len_2 = 0;
  esc = 0;
  for (i = 0; (*&(*by)[i] != 0); (i)++) {
    if (esc) {
      esc = 0;
      *&(tmp)[(len_2)++] = *&(*by)[i];
      continue;
    } //;
#line 184 "regex.arg"
    if ((*&(*by)[i] == '\\')) {
      int n_2 = 0;

#line 185 "regex.arg"
      n_2 = (*&(*by)[(i + 1)] - '0');
      if (((n_2 >= 0) && (n_2 < 10))) {
        int add = 0;

#line 187 "regex.arg"
        add = ((matches)[n_2].rm_eo - (matches)[n_2].rm_so);
        if ((add > 0)) {
          memcpy(((tmp) + len_2), ((((*t) + off)) + (matches)[n_2].rm_so), add);
          len_2 += add;
        } //;
#line 191 "regex.arg"
        (i)++;
      } else {
        esc = 1;
      };
    } else {
#line 195 "regex.arg"
      *&(tmp)[(len_2)++] = *&(*by)[i];
    };
  };
#line 196 "regex.arg"
  if (esc) {
    *&(tmp)[(len_2)++] = '\\';
  } //;
#line 198 "regex.arg"
  *&(tmp)[len_2] = ((char)0);
#line 201 "regex.arg"
  *by = tmp;
  *bylen = len_2;
  return 1;
}

