// generated by: arc -uRNMLP -A ../../libargile -A ../../argrt -o std_field.c -H std_field.h -m std_field.argl std_field.arg 
#include "std_field.h"

#line 41 "std_field.arg"
static argile_field_t * get_field(argile_type_t, char *, field_error_t *, argile_type_t *);
/** :get field <argile type in_type> <text name> <(field_error) & error> <(argile type) & type>: -> (argile) field **/

#line 27 "std_field.arg"
char( argmod_field_doc[]) = {"Call a field of a class or union. It needs a word parameter (field name)\nand a parameter of type `anything' (the union or class instance).\nSyntax requirements:\n  :<any> <word>:\n"};

#line 41 "std_field.arg"
static argile_field_t * get_field(argile_type_t in_type, char * name, field_error_t * error, argile_type_t * type)
/** :get field <argile type in_type> <text name> <(field_error) & error> <(argile type) & type>: -> (argile) field **/
{
  argile_type_info_t * i = ((argile_type_info_t *)0);

#line 43 "std_field.arg"
  in_type = (((int)in_type) & ~((1 << 31)));
  i = argile_type_get_info(in_type);
  *error = NOT_CLASS;
  *type = (argile_type_t)ARGILE_TYPE_NOTHING;
  if (((i) && !((i)->rec))) {
    argile_list_t * lf = ((argile_list_t *)0);
#line 66 "std_field.arg"
    argile_list_t * lc;

#line 49 "std_field.arg"
    if (((i)->ttype == ARGILE_TYPE_KIND_CLASS)) {
      lf = (((i)->tval).t_class).fields;
    } //;
#line 51 "std_field.arg"
    else if (((i)->ttype == ARGILE_TYPE_KIND_UNION)) {
      lf = (((i)->tval).t_union).variants;
    } //;
    if ((lf)) {
      for (; (lf); lf = ((argile_list_t *)lf)->next) {
        argile_field_t * f = ((argile_field_t *)0);

#line 56 "std_field.arg"
        f = *((argile_field_t * *)&((argile_list_t *)lf)->data);
        if (((f)->name == NULL)) {
          *error = INCOMPLETE;
          return ((argile_field_t *)0);
        } //;
#line 60 "std_field.arg"
        if ((strcmp((f)->name, name) == 0)) {
          *error = NONE;
          *type = in_type;
          return f;
        } //;
      };
#line 64 "std_field.arg"
      *error = NOT_FOUND;
    } //;
    lc = (i)->casters;
    for (; (lc); lc = ((argile_list_t *)lc)->next) {
#line 69 "std_field.arg"
      argile_field_t * f = ((argile_field_t *)0);

#line 68 "std_field.arg"
      (i)->rec = 1;
      f = get_field((*((argile_type_caster_t * *)&((argile_list_t *)lc)->data))->to, name, error, type);
      (i)->rec = 0;
      if (((*error == NONE) || (*error == INCOMPLETE))) {
        return f;
      } //;
    };
  } //;
#line 73 "std_field.arg"
  return ((argile_field_t *)0);
}

#line 75 "std_field.arg"
void argmod_field_compile(argile_call_t * p_argile_call)
/** :argmod_field_compile <call>: -> nothing **/
{
#line 76 "std_field.arg"
  argile_shovel_t * sh = ((argile_shovel_t *)0);
  argile_match_t * a = ((argile_match_t *)0);
  argile_match_t * w = ((argile_match_t *)0);
#line 81 "std_field.arg"
  char * word = "";

#line 76 "std_field.arg"
  sh = argile_shovel_new(p_argile_call);
  a = argile_shovel_digmatch(sh, 1, (argile_type_t)ARGILE_TYPE_ANYTHING, (char *)0);
  w = argile_shovel_digmatch(sh, 1, (argile_type_t)ARGILE_TYPE_WORD, (char *)0);
  argile_shovel_del(sh);
  if (((((a) && (w)) && ((a)->type == ARGILE_MATCH_SUBCALL)) && ((word = argile_match_eval_word(w))))) {
#line 82 "std_field.arg"
    argile_call_t * sub = ((argile_call_t *)0);
    field_error_t err;
#line 83 "std_field.arg"
    argile_type_t type_2;

#line 82 "std_field.arg"
    sub = ((a)->value).call;
    (p_argile_call)->data = get_field(argile_call_get_type(sub), word, &err, &type_2);
    if (((p_argile_call)->data == NULL)) {
      argile_die_at(p_argile_call, "std/field: ""%s: no such field", word);
    } //;
  } //;
  else {
    argile_die_at(p_argile_call, "std/field: ""missing subcall or word");
  };
}

#line 91 "std_field.arg"
argile_type_t argmod_field_gettype(argile_call_t * p_argile_call_2)
/** :argmod_field_gettype <call>: -> argile type **/
{
#line 92 "std_field.arg"
  argile_shovel_t * sh = ((argile_shovel_t *)0);
  argile_match_t * a = ((argile_match_t *)0);
  argile_match_t * w = ((argile_match_t *)0);
#line 97 "std_field.arg"
  char * word = "";

#line 92 "std_field.arg"
  sh = argile_shovel_new(p_argile_call_2);
  a = argile_shovel_digmatch(sh, 1, (argile_type_t)ARGILE_TYPE_ANYTHING, (char *)0);
  w = argile_shovel_digmatch(sh, 1, (argile_type_t)ARGILE_TYPE_WORD, (char *)0);
  argile_shovel_del(sh);
  if (((((a) && (w)) && ((a)->type == ARGILE_MATCH_SUBCALL)) && ((word = argile_match_eval_word(w))))) {
#line 98 "std_field.arg"
    field_error_t err;
#line 98 "std_field.arg"
    argile_type_t type_2;
#line 98 "std_field.arg"
    argile_field_t * f = ((argile_field_t *)0);

#line 98 "std_field.arg"
    f = get_field(argile_call_get_type(((a)->value).call), word, &err, &type_2);
    if ((f)) {
      if (((((((int)(p_argile_call_2)->context) >> 31) & 1)) && !((((((int)(f)->type) >> 30) & 1))))) {
        return (((int)(((int)(f)->type) & ((1 << 30) - 1))) | (1 << 31));
      } //;
#line 102 "std_field.arg"
      return (f)->type;
    } //;
  } //;
#line 103 "std_field.arg"
  return ARGILE_TYPE_NOTHING;
}

#line 105 "std_field.arg"
int argmod_field_reject(argile_call_t * p_argile_call_3)
/** :argmod_field_reject <call>: -> int **/
{
#line 107 "std_field.arg"
  argile_shovel_t * sh = ((argile_shovel_t *)0);
  argile_match_t * a = ((argile_match_t *)0);
  argile_match_t * w = ((argile_match_t *)0);
#line 115 "std_field.arg"
  field_error_t error_2;
#line 115 "std_field.arg"
  argile_type_t type_2;
#line 115 "std_field.arg"
  argile_field_t * f = ((argile_field_t *)0);

#line 107 "std_field.arg"
  sh = argile_shovel_new(p_argile_call_3);
  a = argile_shovel_digmatch(sh, 1, (argile_type_t)ARGILE_TYPE_ANYTHING, (char *)0);
  w = argile_shovel_digmatch(sh, 1, (argile_type_t)ARGILE_TYPE_WORD, (char *)0);
  argile_shovel_del(sh);
  if ((a == NULL)) {
#line 464 "../../argrt/std.argl"
    return argile_call_add_reject(p_argile_call_3, "std/field: ""missing class or union parameter");
  } //;
#line 112 "std_field.arg"
  if (((a)->type != ARGILE_MATCH_SUBCALL)) {
#line 464 "../../argrt/std.argl"
    return argile_call_add_reject(p_argile_call_3, "std/field: ""class or union parameter is not a subcall");
  } //;
#line 113 "std_field.arg"
  if ((w == NULL)) {
#line 464 "../../argrt/std.argl"
    return argile_call_add_reject(p_argile_call_3, "std/field: ""missing word parameter");
  } //;
#line 114 "std_field.arg"
  if ((argile_match_eval_word(w) == NULL)) {
#line 464 "../../argrt/std.argl"
    return argile_call_add_reject(p_argile_call_3, "std/field: ""word parameter is not a word");
  } //;
#line 115 "std_field.arg"
  f = get_field(argile_call_get_type(((a)->value).call), ((w)->value).word, &error_2, &type_2);
  if ((f == NULL)) {
    switch (error_2) {
      case INCOMPLETE: {
#line 118 "std_field.arg"
        return argile_call_add_reject(p_argile_call_3, "std/field: ""incomplete class or union at this moment");
      } break;
#line 119 "std_field.arg"
      case NOT_CLASS: {
#line 119 "std_field.arg"
        return argile_call_add_reject(p_argile_call_3, "std/field: ""not a class or union");
      } break;
#line 120 "std_field.arg"
      case NOT_FOUND: ;
      default: {
#line 121 "std_field.arg"
        return argile_call_add_reject(p_argile_call_3, "std/field: ""cannot find this field in this class or union");
      } break;
    };
  } //;
#line 122 "std_field.arg"
  if (((((((int)(f)->type) >> 30) & 1)) && (((((int)(p_argile_call_3)->context) >> 31) & 1)))) {
    return argile_call_add_reject(p_argile_call_3, "std/field: ""field by value in a reference context");
  } //;
#line 124 "std_field.arg"
  return 0;
}

#line 126 "std_field.arg"
void argmod_field_gencode(argile_call_t * p_argile_call_4)
/** :argmod_field_gencode <call>: -> nothing **/
{
#line 127 "std_field.arg"
  argile_shovel_t * sh = ((argile_shovel_t *)0);
  argile_match_t * a = ((argile_match_t *)0);
#line 130 "std_field.arg"
  argile_field_t * f = ((argile_field_t *)0);
#line 138 "std_field.arg"
  argile_type_info_t * i = ((argile_type_info_t *)0);

#line 127 "std_field.arg"
  sh = argile_shovel_new(p_argile_call_4);
  a = argile_shovel_digmatch(sh, 1, (argile_type_t)ARGILE_TYPE_ANYTHING, (char *)0);
  argile_shovel_del(sh);
  f = ((argile_field_t *)(p_argile_call_4)->data);
  argile_gen_ref((p_argile_call_4)->context, (f)->type);
  if (((a)->type != ARGILE_MATCH_SUBCALL)) {
#line 464 "../../argrt/std.argl"
    return;
  } //;
#line 136 "std_field.arg"
  (((a)->value).call)->context = (f)->in_type;
#line 138 "std_field.arg"
  i = argile_type_get_info((f)->in_type);
  if (((i) && ((i)->ttype == ARGILE_TYPE_KIND_UNION))) {
    argile_puts("(");
    argile_match_gencode(a);
    argile_puts(").");
  } //;
#line 143 "std_field.arg"
  else {
    argile_type_t t;
    unsigned char raw;

#line 144 "std_field.arg"
    t = argile_match_get_type(a);
    raw = (((((int)t) >> 30) & 1));
    argile_puts("(");
    if (raw) {
#line 464 "../../argrt/std.argl"
      argile_ref(1);
    } //;
#line 148 "std_field.arg"
    argile_match_gencode(a);
    if (raw) {
      argile_puts(").");
    } //;
#line 151 "std_field.arg"
    else {
      argile_puts(")->");
    };
  };
#line 153 "std_field.arg"
  if (!(((f)->name == NULL))) {
#line 464 "../../argrt/std.argl"
    argile_puts((f)->name);
  } //;
}

