/*  Emacs mode: -*- C++ -*-  */

/*  "Aqua_Surface" with unit gaussian distribution  */

/*
  Copyright (C) 2003  Jocelyn Frchot

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; version 2 of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#ifndef _AQUA_SURFACE_UGAUSSIAN_H
#define _AQUA_SURFACE_UGAUSSIAN_H


/****************  includes  ****************/


#include "aqua_surface.h"


/****************  classes  ****************/


class Aqua_Surface_Ugaussian : public Aqua_Surface
{
 public:

  /*  creates a surface and sets it at time 0.0  */
  Aqua_Surface_Ugaussian(int points_x,
			 int points_z,
			 float size_x,
			 float size_z,
			 float depth,
			 float displacement_factor,
			 class Aqua_Wave_Factory *wave_factory,
			 class Aqua_Wave_Spectrum_Context *spectrum_context,
			 float loop_time = 0.0);


 protected:

  /*  temporary object, used to initialize the base class  */
  class Aqua_Rng_Ugaussian *rng;

  /*  copy constructor to be defined  */
  Aqua_Surface_Ugaussian(const class Aqua_Surface_Ugaussian &);
};


#endif  /*  _AQUA_SURFACE_UGAUSSIAN  */
