/*  Begin get_file_name.cpp  */

/*
  Copyright (C) 2003  Jocelyn Frchot

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; version 2 of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


/****************  includes  ****************/


#include "get_file_name.h"

/*  C lib  */
extern "C"
{
#include <string.h>
}


/****************  functions  ****************/


/*  return a copy of "file_name", removing path if _GNU_SOURCE is defined  */
char *
get_file_name(const char *argv)
{
  char *file_name;

#ifdef _GNU_SOURCE
  file_name = basename(argv);
#else
  file_name = new char[strlen(argv) + 1];
  file_name = argv;
#endif  /*  _GNU_SOURCE  */

  return file_name;
}


/*  End get_file_name.cpp  */
