/*  Begin exceptions.cpp  */

/*
  Copyright (C) 2003  Jocelyn Frchot

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; version 2 of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


/****************  includes  ****************/


#include "exceptions.h"

#include "get_file_name.h"

/*  C++ lib  */
#include <exception>  /*  class exception  */
#include <iostream>   /*  cerr  */
#include <new>        /*  class bad_alloc  */


/****************  namespaces  ****************/


using namespace std;


/****************  functions  ****************/


void
exceptions(char *program_name, const char *exception)
{
  program_name = get_file_name(program_name);

  cerr << "\n"
       << program_name << " error: " << exception
       << endl
    ;
}


void
exceptions(char *program_name, class bad_alloc &exception)
{
  program_name = get_file_name(program_name);

  cerr << "\n"
       << program_name << " error: " << "unable to allocate memory "
       << "(" << exception.what() << ")"
       << endl
    ;
}


void
exceptions(char *program_name, class exception &exception)
{
  program_name = get_file_name(program_name);

  cerr << "\n"
       << program_name << " error: " << "unknown exception " << exception.what()
       << endl
    ;
}


/*  End exceptions.cpp  */
