/*  Emacs mode: -*- C++ -*-  */

/*
  Copyright (C) 2003  Jocelyn Frchot

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; version 2 of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#ifndef CONSTANT_H
#define CONSTANT_H


/****************  includes  ****************/


/*  GSL lib  */
extern "C"
{
#include <gsl/gsl_const_mksa.h>
}

/*  C lib  */
extern "C"
{
#include <math.h>
}


/****************  macros  ****************/


/*  mathematical macros (prefixed with "M_") are not part of ISO C  */

#ifndef M_PI
#define M_PI 3.14159265358979323846
#endif  /*  M_PI  */
#ifndef M_PI_2
#define M_PI_2 1.57079632679489661923
#endif  /*  M_PI_2  */


/****************  constants  ****************/


/*  physical constants  */

/*  the standard gravitational acceleration on Earth, g  */
const float Constant_g                    = GSL_CONST_MKSA_GRAV_ACCEL; /*m.s-2*/
/*  obliquity of the ecliptic (rough)  */
const float Constant_ecliptic_obliquity   = 23.5;  /*  degrees  */
const float Constant_sun_angular_diameter = 0.5;   /*  degrees  */

/*  mathematical constants  */

/*  pi  */
const float Constant_pi      = M_PI;        /*  pi      */
const float Constant_2_pi    = M_PI * 2.0;  /*  pi * 2  */
const float Constant_pi_by_2 = M_PI_2;      /*  pi / 2  */
/*  conversions  */
const float Constant_deg_to_rad = M_PI / 180.0;  /*  degrees to radians  */
const float Constant_ms_to_kmh  = 3.6;           /*  m.s-1 to km/h  */


#endif  /*  CONSTANT_H  */
