/*  Begin help.cpp  */

/*
  Copyright (C) 2003  Jocelyn Frchot

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; version 2 of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


/****************  includes  ****************/


#include "help.h"

#include "config.h"

/*  C++ lib  */
#include <sstream>
#include <string>


/****************  namespaces  ****************/


using namespace std;


/****************  public functions  ****************/


Help::Help(void)
  :
  /*  general  */
  Key_help(Config_help_help),
  Key_quit(Config_help_quit),
  Key_pause(Config_help_pause),
  Key_info(Config_help_info),
  Key_fps(Config_help_fps),
  Key_stone(Config_help_stone),
  /*  camera  */
  Key_view(Config_help_view),
  /*  surface look  */
  Key_wire(Config_help_wire),
  Key_normals(Config_help_normals),
  Key_tiled(Config_help_tiled),
  Key_surface_alpha_decrease(Config_help_surface_alpha_decrease),
  Key_surface_alpha_increase(Config_help_surface_alpha_increase),
  /*  surface physics  */
  Key_points_decrease(Config_help_points_decrease),
  Key_points_increase(Config_help_points_increase),
  Key_points_x_decrease(Config_help_points_x_decrease),
  Key_points_x_increase(Config_help_points_x_increase),
  Key_points_z_decrease(Config_help_points_z_decrease),
  Key_points_z_increase(Config_help_points_z_increase),
  Key_size_decrease(Config_help_size_decrease),
  Key_size_increase(Config_help_size_increase),
  Key_size_x_decrease(Config_help_size_x_decrease),
  Key_size_x_increase(Config_help_size_x_increase),
  Key_size_z_decrease(Config_help_size_z_decrease),
  Key_size_z_increase(Config_help_size_z_increase),
  Key_depth_decrease(Config_help_depth_decrease),
  Key_depth_increase(Config_help_depth_increase),
  Key_displacement_factor_decrease(Config_help_displacement_factor_decrease),
  Key_displacement_factor_increase(Config_help_displacement_factor_increase),
  Separator(Config_help_separator),
  Message(this->create_message(this->Separator))
{
}


/*  virtual destructor  */
Help::~Help(void)
{
}


const string *
Help::get_message(void) const
{
  return &this->Message;
}


/****************  protected functions  ****************/


string
Help::create_message(const char *separator)
{
  ostringstream temp_stream;

  temp_stream << "This help: " << this->Key_help << "\n"
	      << "Quit: " << this->Key_quit << "\n"
	      << "Pause: " << this->Key_pause << "\n"
	      << "Show info: " << this->Key_info << "\n"
	      << "Frames per seconde: " << this->Key_fps << "\n"
	      << "Graduated stone: " << this->Key_stone << "\n"
	      << "\n"
	      << "Camera" << "\n"
	      << "  switch view mode (observing / flying / swimming): "
	        << this->Key_view << "\n"
	      << "  forward / backward / right / left: arrow keys" << "\n"
	      << "  up / down: page-up / page-down" << "\n"
	      << "\n"
	      << "Surface look" << "\n"
	      << "  wire mode: " << this->Key_wire << "\n"
	      << "  normals (in wire mode): " << this->Key_normals << "\n"
	      << "  tiled surface: " << this->Key_tiled << "\n"
	      << "  increase / decrease surface alpha: "
	        << this->Key_surface_alpha_increase
	        << separator << this->Key_surface_alpha_decrease << "\n"
	      << "\n"
	      << "Surface physics" << "\n"
	      << "  increase / decrease number of points: "
	        << this->Key_points_increase
	        << separator << this->Key_points_decrease
	        << " (X and Z direction: " << this->Key_points_x_increase
	        << separator << this->Key_points_x_decrease
	        << " and " << this->Key_points_z_increase
	        << separator << this->Key_points_z_decrease << ")\n"
	      << "  increase / decrease surface size: "
	        << this->Key_size_increase
	        << separator << this->Key_size_decrease
	        << " (X and Z direction: " << this->Key_size_x_increase
	        << separator << this->Key_size_x_decrease
	        << " and " << this->Key_size_z_increase
	        << separator << this->Key_size_z_decrease << ")\n"
	      << "  increase / decrease displacement factor: "
	        << this->Key_displacement_factor_increase
	        << separator << this->Key_displacement_factor_decrease << "\n"
	      << "  increase / decrease depth: "
	        << this->Key_depth_increase
	        << separator << this->Key_depth_decrease << "\n"
    ;

  return temp_stream.str();
}


/*  End help.cpp  */
