/*  Emacs mode: -*- C++ -*-  */

/*
  Copyright (C) 2003  Jocelyn Frchot

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; version 2 of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#ifndef FILE_H
#define FILE_H


/****************  includes  ****************/


/*  C++ lib  */
#include <istream>
#include <ostream>


/****************  namespaces  ****************/


using namespace std;


/****************  abstract classes  ****************/


class File
{
 public:

  /*  read from stdin?  */
  const bool Is_input_stream_cin;
  /*  write to stdout?  */
  const bool Is_output_stream_cout;

  /*  variables  */
  int points_x;
  int points_z;
  float size_x;
  float size_z;
  float depth;
  float displacement_factor;
  int loop_time;
  int frames_per_second;


  /*
    If "input_file" == NULL, reads from stdin.
    If "output_file" == NULL, writes to stdout.
  */
  File(char *input_file, char *output_file) throw(const char *);

  virtual ~File(void) = 0;


  /****  read  ****/

  /*  reads "Input_file" and initializes variables  */
  virtual void read_configure(void) throw(const char *);
  /*  reads "Input_file" and initializes variables  */
  virtual void read_header(void) throw(const char *);
  /*  reads data from "Input_file"  */
  void read(float ***data) const throw(const char *);


  /****  write  ****/

  /*  writes template file (i.e. variables strings) into "Output_file"  */
  virtual void write_configure_template(void) const throw(const char *);
  /*  writes header into "Output_file"  */
  virtual void write_header(void) const throw(const char *);
  /*  writes "data" into "Output_file"  */
  void write(float ***data) const throw(const char *);


 protected:

  /*  file names  */
  const char * const Input_file;
  const char * const Output_file;
  /*  error messages  */
  const char * const Error_message_open;
  const char * const Error_message_read;
  const char * const Error_message_write;
  /*  streams  */
  istream * const Input_stream;
  ostream * const Output_stream;
  /*  variables strings  */
  const char * const String_points_x;
  const char * const String_points_z;
  const char * const String_size_x;
  const char * const String_size_z;
  const char * const String_depth;
  const char * const String_displacement_factor;
  const char * const String_loop_time;
  const char * const String_frames_per_second;
  /*  string appends to each variable string  */
  const char * const String_end;


  /*  get  */

  const char * get_error(const char *message, const char *file_name) const;
  /*  return ifstream("Input_file") or "cin" if ("Input_file" == NULL)  */
  istream *get_input_stream(const char *input_file) const throw(const char *);
  /*  return ofstream("Output_file") or "cout" if ("Output_file" == NULL)  */
  ostream *get_output_stream(const char *output_file) const throw(const char *);
  bool get_is_input_stream_cin(char *input_file) const;
  bool get_is_output_stream_cout(char *output_file) const;

  /*  check  */
  void check_stream(istream *stream, const char *message, const char *file_name)
    const throw(const char *);
  void check_stream(ostream *stream, const char *message, const char *file_name)
    const throw(const char *);



  /*  copy constructor to be defined  */
  File(const class File &);
};


#endif  /*  FILE_H  */
