/*  Begin file.cpp  */

/*
  Copyright (C) 2003  Jocelyn Frchot

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; version 2 of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


/****************  includes  ****************/


#include "file.h"

/*  C++ lib  */
#include <fstream>
#include <iostream>
#include <istream>
#include <ostream>
#include <sstream>  /*  "get_error()"  */
#include <string>   /*  "read_configure()"  */


/****************  namespaces  ****************/


using namespace std;


/**************************************************/
/****************  class File_Base ****************/
/**************************************************/


/****************  public functions  ****************/


File::File(char *input_file, char *output_file) throw(const char *)
  : Is_input_stream_cin(this->get_is_input_stream_cin(input_file)),
    Is_output_stream_cout(this->get_is_output_stream_cout(output_file)),
    /*  files names  */
    Input_file(input_file),
    Output_file(output_file),
    /*  error messages, should be defined before streams  */
    Error_message_open("unable to open file"),
    Error_message_read("unable to read from file"),
    Error_message_write("unable to write to file"),
    /*  streams  */
    Input_stream(this->get_input_stream(input_file)),
    Output_stream(this->get_output_stream(output_file)),
    /*  variables strings  */
    String_points_x("points_x"),
    String_points_z("points_z"),
    String_size_x("size_x"),
    String_size_z("size_z"),
    String_depth("depth"),
    String_displacement_factor("displacement_factor"),
    String_loop_time("loop_time"),
    String_frames_per_second("frames_per_second"),
    /*  string appends to each variable string  */
    String_end(" \n")
{
}


File::~File(void)
{
  if (!this->Is_input_stream_cin)
    {
      delete this->Input_stream;
    }
  if (!this->Is_output_stream_cout)
    {
      delete this->Output_stream;
    }
}


/****  read  ****/


/*  reads "Input_file" and initializes variables  */
void
File::read_configure(void) throw(const char *)
{
  string temp;

  *this->Input_stream >> temp >> this->points_x
		      >> temp >> this->points_z
		      >> temp >> this->size_x
		      >> temp >> this->size_z
		      >> temp >> this->depth
		      >> temp >> this->displacement_factor
		      >> temp >> this->loop_time
		      >> temp >> this->frames_per_second
    ;

  this->check_stream(this->Input_stream,
		     this->Error_message_read,
		     this->Input_file);
}


/*  reads "Input_file" and initializes variables  */
void
File::read_header(void) throw(const char *)
{
  *this->Input_stream >> this->points_x
		      >> this->points_z
		      >> this->size_x
		      >> this->size_z
		      >> this->depth
		      >> this->displacement_factor
		      >> this->loop_time
		      >> this->frames_per_second
    ;

  this->check_stream(this->Input_stream,
		     this->Error_message_read,
		     this->Input_file);
}


/*  reads data from "Input_file"  */
void
File::read(float ***data) const throw(const char *)
{
  int i, j, k;

  for (i = 0; i < 3; i++)
    {
      for (j = 0; j < this->points_x; j++)
	{
	  for (k = 0; k < this->points_z; k++)
	    {
	      *this->Input_stream >> data[i][j][k];
	    }
	}
    }

  this->check_stream(this->Input_stream,
		     this->Error_message_read,
		     this->Input_file);
}


/****  write  ****/

/*  writes template file (i.e. variables strings) into "Output_file"  */
void
File::write_configure_template(void) const throw(const char *)
{
  *this->Output_stream << this->String_points_x << this->String_end
		       << this->String_points_z << this->String_end
		       << this->String_size_x << this->String_end
		       << this->String_size_z << this->String_end
		       << this->String_depth << this->String_end
		       << this->String_displacement_factor << this->String_end
		       << this->String_loop_time << this->String_end
		       << this->String_frames_per_second << this->String_end
		       << flush
    ;

  this->check_stream(this->Output_stream,
		     this->Error_message_write,
		     this->Output_file);
}


/*  writes header into "Output_file"  */
void
File::write_header(void) const throw(const char *)
{
  *this->Output_stream << this->points_x << " "
		       << this->points_z << " "
		       << this->size_x << " "
		       << this->size_z << " "
		       << this->depth << " "
		       << this->displacement_factor << " "
		       << this->loop_time << " "
		       << this->frames_per_second << " "
		       << flush
    ;

  this->check_stream(this->Output_stream,
		     this->Error_message_write,
		     this->Output_file);
}


/*  writes "data" into "Output_file"  */
void
File::write(float ***data) const throw(const char *)
{
  int i, j, k;

  for (i = 0; i < 3; i++)
    {
      for (j = 0; j < this->points_x; j++)
	{
	  for (k = 0; k < this->points_z; k++)
	    {
	      *this->Output_stream << data[i][j][k] << " ";
	    }
	}
    }
  /*  *this->Output_stream << flush; ?  */

  this->check_stream(this->Output_stream,
		     this->Error_message_write,
		     this->Output_file);
}


/****************  protected functions  ****************/


/****  get  ****/

const char *
File::get_error(const char *message, const char *file_name) const
{
  ostringstream temp_stream;

  temp_stream << message << " " << file_name << endl;

  return temp_stream.str().data();
}


/*  return ifstream("Input_file") or "cin" if ("Input_file" == NULL)  */
istream *
File::get_input_stream(const char *input_file) const throw(const char *)
{
  istream *temp;

  if (input_file == NULL)
    {
      temp = &cin;
    }
  else
    {
      temp = new ifstream(input_file);

      this->check_stream(temp, this->Error_message_open, input_file);
    }

  return temp;
}


/*  return ofstream("Output_file") or "cout" if ("Output_file" == NULL)  */
ostream *
File::get_output_stream(const char *output_file) const throw(const char *)
{
  ostream *temp;

  if (output_file == NULL)
    {
      temp = &cout;
    }
  else
    {
      temp = new ofstream(output_file);

      this->check_stream(temp, this->Error_message_open, output_file);
    }

  return temp;
}


bool
File::get_is_input_stream_cin(char *input_file) const
{
  bool temp;

  if (input_file == NULL)
    {
      temp = true;
    }
  else
    {
      temp = false;
    }

  return temp;
}


bool
File::get_is_output_stream_cout(char *output_file) const
{
  bool temp;

  if (output_file == NULL)
    {
      temp = true;
    }
  else
    {
      temp = false;
    }

  return temp;
}


/****  check  ****/

void
File::check_stream(istream *stream, const char *message, const char *file_name)
  const throw(const char *)
{
  if (!*stream)
    {
      throw this->get_error(message, file_name);
    }
}


void
File::check_stream(ostream *stream, const char *message, const char *file_name)
  const throw(const char *)
{
  if (!*stream)
    {
      throw this->get_error(message, file_name);
    }
}


/*  End file.cpp  */
