#!/bin/bash

echo "
----------------------------------------------------------------
This program will set up an Apso public repository for you,
using Monotone as the back end VC system.

You can configure options in ./apso-setup.cfg (it will be
read in the beginning of this script). Any missing information
will be asked by this script.

IMPORTANT: this only sets up the PUBLIC repository. Your private
database should be set up using Monotone.
----------------------------------------------------------------
"

if [ -f ./apso-setup.cfg ]; then
	. ./apso-setup.cfg
fi

if [ -z $DB ]; then
	echo -n "Monotone public database? "
	read DB
fi
if [ -z $KEY ]; then
	echo -n "Monotone private key? "
	read KEY
fi
if [ -z $WC ]; then
	echo -n "Path to public database working copy? "
	read WC
fi
if [ -z $USR ]; then
	echo -n "Your username in Apso public repository? "
	read USR
fi
if [ -z $PUBK ]; then
	echo "The current path (in case you need to cut&paste) is: " `pwd`
	echo -n "Public key for Nettle (ABSOLUTE path)? "
	read PUBK
fi

CURRENT_DIR=`pwd`

cd $CURRENT_DIR
mtn -k $KEY -d $DB db init
mtn -k $KEY -d $DB setup -b apso $WC

cd $WC
mkdir deltas
mkdir delta_dependencies
mkdir keymap
mkdir users
mkdir users/$USR
mkdir users/$USR/keys
cp $PUBK users/$USR/public_key
# FIXME:
# If any of the above command fails, we should stop and show the user a
# big warning!

mtn -k $KEY add -R deltas delta_dependencies users keymap 
mtn -k $KEY ci -m "Initial setup of Apso public database"

cd $CURRENT_DIR

echo "Apso public database setup complete."

