#ifndef SINGLETON_H
#define SINGLETON_H

/**
 * Singleton template.
 *
 * Not thread-safe.
 *
 * This a very simple template, taken from Wikipedia:
 * http://en.wikipedia.org/wiki/Singleton_pattern#C.2B.2B_example_implementation
 */
template<typename T> class Singleton
{
  public:
    static T& get_instance()
    {
        static T theSingleInstance; // Assumes T has a default constructor
        return theSingleInstance;
    }
};

#endif

