/*
 * repository.cpp
 *
 * Copyright (C) 2006 Jernimo Pellegrini
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to:
 *   The Free Software Foundation, Inc.,
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <iostream>
#include <list>
#include <string>
#include <typeinfo>
#include <iostream>

#include "boost/filesystem/operations.hpp"

#include "repository.h"
#include "bdata.h"

namespace apso {

/**
 * Adds a file to the database (under version control).
 *
 * Will not commit.
 */
void
Repository::add(const Path& path, const bdata& content) {
	vc->add_file(path, content);
	vc->commit();
}

/**
 * Adds a file to the repository.
 *
 * @param path The *relative* path to the file.
 */
void
Repository::add_file(const Path& path) {
	vc->add_file(path);
	vc->commit();
}

/**
 * Adds a directory to the repository.
 *
 * @param path The *relative* path to the directory.
 */
void
Repository::add_dir(const Path& path) {
	vc->add_directory(path);
	vc->commit();
}

/**
 * Commits changes to the repository.
 */
void Repository::commit() {
	vc->commit();
}

/**
 * Sets up a repository.
 */
void
Repository::setup() {
}

/**
 * Descructor.
 */
Repository::~Repository() {
}

}
