/*
 * vcrepository.h
 *
 * Copyright (C) 2006 Jernimo Pellegrini
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to:
 *   The Free Software Foundation, Inc.,
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef VCREPOSITORY
#define VCREPOSITORY

#include <list>
#include <string>

#include <boost/filesystem/path.hpp>
#include <boost/shared_ptr.hpp>

#include "utils.h"
#include "delta.h"


namespace apso {
	
/**
 * Representation of a repository.
 *
 * The Repository class deals with the abstract idea of an Apso database,
 * but it does now know anything about particular version control systems.
 * This is VC-specific, derived classes should be made for each VC system.
 */
class VCRepository {
public:
	virtual boost::shared_ptr<std::list<Delta_ptr> > get_deltas(const boost::shared_ptr<std::list<std::string> > ids) = 0;
	virtual boost::shared_ptr<std::list<std::string> > get_revision_ids() = 0;
	virtual Path& get_wc_path() = 0;
	virtual void accept_deltas(const std::list<Delta_ptr>& deltas) = 0;
	virtual void add_file(const Path& path, const bdata& content) = 0;
	virtual void add_file(const Path& path) = 0;
	virtual void add_directory(const Path& path) = 0;
	virtual void remove_file(const Path& path) = 0;
	virtual void remove_directory(const Path& path) = 0;
	virtual void update_wc() = 0;
	virtual void update_wc(Path& path) = 0;
	virtual const std::list<Path_ptr> list_known(const Path&) = 0;
	virtual void commit() = 0;
	virtual ~VCRepository();
};

typedef boost::shared_ptr<VCRepository> VCRepository_ptr;

}

#endif
