/*
 * privrepository.h
 *
 * Copyright (C) 2006 Jernimo Pellegrini
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to:
 *   The Free Software Foundation, Inc.,
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef PRIVREPOSITORY_H
#define PRIVREPOSITORY_H

#include <list>
#include <string>

#include <boost/filesystem/path.hpp>

#include "vcrepository.h"
#include "repository.h"
#include "delta.h"

namespace apso {

/**
 * Represents a private repository.
 *
 * Private repositories are not encrypted. This is just a wrapper over
 * version control systems.
 */
class PrivRepository : public Repository {
public:
	~PrivRepository();
	PrivRepository(VCRepository_ptr v);
	std::list<Delta_ptr> get_deltas();
	void accept_deltas (const std::list<Delta_ptr>&);
};

typedef boost::shared_ptr<PrivRepository> PrivRepository_ptr;

}

#endif
