/*
 * facade.h
 *
 * Copyright (C) 2006 Jernimo Pellegrini
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to:
 *   The Free Software Foundation, Inc.,
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef FACADE_H
#define FACADE_H

#include "options.h"

namespace apso {

/**
 * This is a faade with an API for Apso.
 */
class Facade {
public:
	void grant(Setup& opt);
	void revoke(Setup& opt);
	void genkey(Setup& opt);
	void setup(Setup& opt);
	void pull(Setup& opt);
	void push(Setup& opt);
	void sync(Setup& opt);
	void compromise(Setup& opt);
};

typedef boost::shared_ptr<Facade> Facade_ptr;

}
#endif
