/*
 * key.h
 *
 * Copyright (C) 2006 Jernimo Pellegrini
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to:
 *   The Free Software Foundation, Inc.,
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef KEY_H
#define KEY_H

#include <string>

#include <boost/shared_ptr.hpp>

#include "bdata.h"

namespace apso {

/**
 * Represents a cryptographic key.
 *
 * This is a wrapper over the C-style char* key and an int with its size.
 */
class Key {
private:
	std::string id;
	bdata value;
public:
	Key();
	Key(const Path& path);
	std::string get_id() const;
	void set_id(const std::string& id);
	void auto_set_id();
	int get_size() const;
	char * get_value() const;
	std::string get_string() const;
	void set_value(const bdata& b);
	void save(const Path& path);
};

typedef boost::shared_ptr<Key> Key_ptr;

}

#endif
