/*
 * ceyptengine.cpp
 *
 * Copyright (C) 2006 Jernimo Pellegrini
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to:
 *   The Free Software Foundation, Inc.,
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */


#include "cryptengine.h"

namespace apso {

CryptEngine::CryptEngine() {
}
	
CryptEngine::~CryptEngine() {
}


/**
 * Does symmetric encryption.
 */
char *
CryptEngine::sym_enc (const char *text, Key& key, unsigned *size)
	throw (std::runtime_error, std::bad_alloc) {
	char *k = key.get_value();
	return sym_enc (text, k, size, key.get_size ());
}

/**
 * Does symmetric decryption.
 */
char *
CryptEngine::sym_dec (const char *enctext, Key& key, unsigned *size)
	throw (std::runtime_error, std::bad_alloc) {
	const char *k = key.get_value();
	return sym_dec (enctext, k, size, key.get_size ());
}

/**
 * Does asymmetric encryption.
 */
char *
CryptEngine::asym_enc (const char *text, Key& pubk, unsigned *size) 
	throw (std::runtime_error, std::bad_alloc) {
	const char *k = pubk.get_value();
	return asym_enc (text, k, size, pubk.get_size ());
}

/**
 * Does asymmetric decryption.
 */
char *
CryptEngine::asym_dec (const char *enctext, Key& prik, unsigned *size) 
	throw (std::runtime_error, std::bad_alloc) {
	const char *k = prik.get_value();
	return asym_dec (enctext, k, size, prik.get_size ());
}

/**
 * Does symmetric encryption.
 */
std::string
CryptEngine::sym_enc  (const std::string& text,    Key& key,  unsigned *size) throw (std::runtime_error, std::bad_alloc) {
	const char *k = key.get_value();
	char *tmp_s = sym_enc (text.data(), k, size, key.get_size ());
	boost::shared_ptr<std::string> s (new std::string(tmp_s,*size));
	return *s;
}

/**
 * Does symmetric decryption.
 */
std::string
CryptEngine::sym_dec  (const std::string& enctext, Key& key,  unsigned *size) throw (std::runtime_error, std::bad_alloc) {
	const char *k = key.get_value();
	char *tmp_s = sym_dec (enctext.data(), k, size, key.get_size ());
	boost::shared_ptr<std::string> s (new std::string(tmp_s,*size));
	return *s;
}

/**
 * Asymmetric decryption.
 */
std::string
CryptEngine::asym_enc (const std::string& text,    Key& pubk, unsigned *size) throw (std::runtime_error, std::bad_alloc) {
	const char *k = pubk.get_value();
        char *tmp_s = asym_enc (text.data(), k, size, pubk.get_size ());
        boost::shared_ptr<std::string> s (new std::string(tmp_s,*size));
        return *s;
}

/**
 * Asymetric decryption.
 */
std::string
CryptEngine::asym_dec (const std::string& text,    Key& prik, unsigned *size) throw (std::runtime_error, std::bad_alloc) {
	const char *k = prik.get_value();
        char *tmp_s = asym_dec (text.data(), k, size, prik.get_size ());
        boost::shared_ptr<std::string> s (new std::string(tmp_s,*size));
        return *s;
}

}

