<?php

/* Appora server
 * Copyright (C) 2011 Appora contributors
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Description of AttributesMask to filter ApplicationDescriptor attributes.
 */
class AttributesMask {

	private function __construct() {

	}

	const ATTR_NAME = 1;
	const ATTR_DESCRIPTION = 2;
	const ATTR_IDENTIFIER = 4;
	const ATTR_WEBSITE = 8;
	const ATTR_ICON = 16;
	const ATTR_BRANCHES = 32;

	const ATTR_ALL = 63;

	/** Convert an array of attribute names to a bitmask.
	 * @param array $aAttrs Array of attribute names. Accepted values are
	 * "id", "name", "desc", "website", "branches"
	 */
	public static function getMask($aAttrs) {
		$mask = 0;
		foreach ($aAttrs as $attr) {
			if ($attr == "id") {
				$mask |= AttributesMask::ATTR_IDENTIFIER;
			} else if ($attr == "name") {
				$mask |= AttributesMask::ATTR_NAME;
			} else if ($attr == "desc") {
				$mask |= AttributesMask::ATTR_DESCRIPTION;
			} else if ($attr == "website") {
				$mask |= AttributesMask::ATTR_WEBSITE;
			} else if ($attr == "branches") {
				$mask |= AttributesMask::ATTR_BRANCHES;
			}
		}
		return $mask;
	}

}

?>
