<?php

/* Appora server
 * Copyright (C) 2011 Appora contributors
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

require_once(dirname(__FILE__)."/../../env.php");
require_once($_LOGGER_MODULES_DIR."/ILogger.php");

/** A logger that writes on output. This should be NOT used for other purpose
 * as debugging as it may output things before response header is set.
 */
class EchoLogger implements ILogger {

	public function __construct() { }

	public function logError($sSource, $sMessage, $exception) {
		if ($exception !== NULL) {
			echo("[ERROR]".$sSource.": ".$sMessage." - caused by\n"
				.$exception."\n");
		} else {
			echo("[ERROR]".$sSource.": ".$sMessage."\n");
		}
	}

	public function logWarning($sSource, $sMessage, $exception) {
		if ($exception !== NULL) {
			echo("[WARNING]".$sSource.": ".$sMessage." - "
				.$exception."\n");
		} else {
			echo("[WARNING]".$sSource.": ".$sMessage."\n");
		}
	}

	public function logDebug($sSource, $sMessage) {
		echo("[DEBUG]".$sSource." ".$sMessage."\n");
	}

}
?>
