<?php

/* Appora server
 * Copyright (C) 2011 Appora contributors
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

require_once(dirname(__FILE__) . "/../env.php");

/** Abstract helper class for service */
abstract class AService {

	/** Service name (for Log). Set it on implementation consctructor */
	protected $name;	

	/** Log an error through _LOG and return 500 Internal error.
	 * @param $sErrorMessage String The error message to log.
	 * @param $error Exception The exception that caused the error (nullable).
	 */
	protected function reportInternalError($sErrorMessage, $error = NULL) {
		global $server, $response, $header;
		$server->getLoggerModule()->logError($this->name, $sErrorMessage,
				$error);
		$header = "HTTP/1.0 500 Internal error";
		$response = "";
	}

	/** Send 400 Bad Request with a message.
	 * @param $sMessage String The message to send to client.
	 */
	protected function reportBadRequest($sMessage) {
		global $response, $header;
		$header = "HTTP/1.0 400 Bad request";
		$response = $sMessage;
	}

	protected function reportNoData($sMessage) {
		global $response, $header;
		$header = "HTTP/1.0 204 No data";
		$response = $sMessage;
	}

	/** Implement this function to run the service.
	 * It must set globals $header and $response.
	 */
	public abstract function run();
}

?>