/*rip.c
*
*    Copyright (C) 2004, 2005 Jonathan Gonzalez V. <jonathan@blueplanet.cl>
*
*    http://www.nongnu.org/apolos
*
*    This file is part of apolos.
*
*    Apolos is free software; you can redistribute it and/or modify
*    it under the terms of the GNU General Public License as published by
*    the Free Software Foundation; either version 2 of the License, or
*    (at your option) any later version.
*
*    This program is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*    GNU General Public License for more details.
*
*    You should have received a copy of the GNU General Public License
*    along with this program; if not, write to the Free Software
*    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


/*
 * The code on this page doesn't work if you want you can help :)
 * I have to say, the lines and the names of the variables are like 
 * that in main.c of cdparanoia. I hope and I want to change the code 
 * to create a better way :)
*/

#include"types.h"
#include"utils.h"
#include"graf.h"

#include"rip.h"
#include"encode.h"

#include<stdio.h>
#include<stdlib.h>
#include<fcntl.h>
#include<unistd.h>
#include<string.h>

#include<gtk/gtk.h>

#include<cdda_interface.h>
#include<cdda_paranoia.h>

void WriteWav (int fd, long bytes); /* Write the header of the wav file */

int buffer_write (int fd, char *buffer, long num); /* Write the 'data' in wav file */

gchar *
make_file_name (Tracklist *tracklist)
{
  gchar *file_name = (gchar *) calloc (250, sizeof (gchar *));
  
  g_snprintf (file_name, 250, "%s - %s", 
	      strcmp (tracklist->artista->texto, "") == 0 ? "Track" : tracklist->artista->texto, 
	      strcmp (tracklist->titulo->texto, "") == 0 ? g_strdup_printf ("%d", tracklist->track) : tracklist->titulo->texto);

  return file_name;
}

void *
rip (void *data)
{
  DatosCD *datos = (DatosCD *) data;
  Tracklist *header = datos->cd->header;
  Tracklist *tracks = datos->cd->header;

  gchar *file_name = (gchar *) calloc (250, sizeof (gchar *));
  //  Tracklist *tracklist = Find_Track (datos->cd, 1);

  datos->rip->ripping = TRUE;
  datos->rip->encoding = TRUE;

  do {
    /* If the user want to rip this track */
    if (tracks->rip == TRUE)
      {
	/* First in the statusbar we put the name of the current ripping track */
	MSG_to_Statusbar (datos->graf, g_strdup_printf ("Ripping: %s", make_file_name (tracks)));	
	/* We create the file_name of the track that we'll put into /tmp or the temp_files choiced by the user */ 
	g_snprintf (file_name, 250, "%s/%s", datos->rip->temp_files, make_file_name (tracks));
	/* We rip the track */
	rip_track (tracks, datos->cd, datos->rip, file_name);      
	/* We remove the ripping message from the statusbar*/
	remove_MSG_Statusbar (datos->graf);
	/* We put the name of the track that we're encoding on ogg in the status bar */
	MSG_to_Statusbar (datos->graf, g_strdup_printf ("OGG Encoding: %s", make_file_name (tracks)));
	/* We encode the track */
	Encode (datos, tracks);
	/* We remove the encodding message from the statusbar */
	remove_MSG_Statusbar (datos->graf);
      }
    
    tracks = tracks->next;
  } while (tracks != header);
  
  datos->rip->ripping = FALSE;
  datos->rip->encoding = FALSE;

  return 0;
}
  
long call_begin, call_end;

gint 
rip_track (Tracklist *tracklist, Datos *cd, Rip *rip, gchar *file_name)
{
  int ret;
  int out_fd;
  int mode = PARANOIA_MODE_FULL^PARANOIA_MODE_NEVERSKIP;
  int16_t *readbuf;
  long first_sector, last_sector, cursor;
  long batch_first, batch_last;
  gchar *file_name_out = (char *) calloc (255, sizeof (char *)); /* 255 it's the max size of a filename ?*/
  cdrom_drive *d;/*    This name are the sames of */
  cdrom_paranoia *p;/* cdparanoia.c in cdparanoia */


  g_snprintf (file_name_out, 255, "%s.wav", file_name);

  /*
    We identify the type of device and if we have access.
    If we can't access the device cdda_identify return NULL.
    This part of the code it's fine for the moment, but 
   */
  d = cdda_identify (cd->cd_device, CDDA_MESSAGE_PRINTIT, NULL);
  
  if (d == NULL)
    {
      printf ("error\n");
      exit (1);
    }

  cdda_verbose_set ( d, CDDA_MESSAGE_PRINTIT,  CDDA_MESSAGE_PRINTIT);

  paranoia_init (d); 
  
  ret = cdda_open (d); 
  
  first_sector = cdda_track_firstsector (d, tracklist->track);
  last_sector = cdda_track_lastsector (d, tracklist->track);
  
  p = paranoia_init (d); 
  
  paranoia_modeset (p, mode);
  
  cdda_verbose_set(d,CDDA_MESSAGE_LOGIT,CDDA_MESSAGE_LOGIT);
  
  paranoia_seek(p,cursor=first_sector,SEEK_SET);
  
  while (cursor <= last_sector) /* We check all sectors*/
    {
      batch_first = cursor;
      batch_last = cdda_track_lastsector (d, tracklist->track);
      
      call_begin = batch_first;
      call_end = batch_last;
       
      out_fd = open (file_name_out,O_RDWR|O_CREAT|O_TRUNC,0666);
      
      WriteWav (out_fd, (batch_last-batch_first+1)*CD_FRAMESIZE_RAW);

      while (cursor <= batch_last)
	{
	  readbuf = paranoia_read_limited (p, progress, 20); /* We can/should be the NULL by a function */
	  
	  progress (cursor*(CD_FRAMEWORDS) - 1, -2);

	  buffer_write (out_fd, (char *)readbuf, CD_FRAMESIZE_RAW);
	  cursor++;
	  
	  progress (cursor * (CD_FRAMEWORDS), -2);
	  
	}
      
      if (cursor > batch_last)
	progress (cursor * (CD_FRAMEWORDS), -2);
      
    }

  progress (cursor * (CD_FRAMESIZE_RAW/2) - 1, -1);

  close (out_fd);
  ret = cdda_close (d);
  
  paranoia_free (p);
  return 0;
}

void
WriteWav (int fd, long bytes)
{
  struct __wav {
    /* RIFF header */
    unsigned char id[4];
    unsigned long int len;
    
    /* WAVE header */
    unsigned char type[4]; /* RIFF type, in this case is WAVE */
    unsigned char fmt[4]; /* 'fmt ' */
    
    unsigned long int format; /* 16-bits or 8-bits */
    unsigned short int formatcat; /* 0x001 (1) if is a WAVE PCM */
    
    unsigned short int channels; /* Channels */
    unsigned long int samplepersec; /* Sample per Sec */
    unsigned long int bytespersec; /* Bytes per Sec  */
    unsigned short int blockalign; /* Block align */
    unsigned short int bitspersample; /* Bits per Sample */

    unsigned char data[4]; /* 'data' */
    unsigned long int wave_data; /* WAVE data */
  } wav;

  sprintf (wav.id, "RIFF");
  wav.len = bytes+36; /* 36 are the bytes of the WAVE header */
  sprintf (wav.type, "WAVE");
  sprintf (wav.fmt, "fmt ");
  wav.format = 16;
  wav.formatcat = 1; /* in hexadecimal is: 0x0001 */
  wav.channels = 2;
  wav.samplepersec = 44100;
  wav.bytespersec = 44100*2*2;
  wav.blockalign = 4;
  wav.bitspersample = 16;
  sprintf (wav.data, "data");
  wav.wave_data = bytes;

  write (fd, &wav, sizeof (wav));

}

int
buffer_write (int fd, char *buffer, long num)
{
  write (fd, buffer, num);

  return 0;
}

static void 
progress (long inpos, int function)
{
  long sector, osector;
  static int overlap = 0;
  static long v_sector;
  int position;
  
  osector = inpos;
  sector = inpos/CD_FRAMEWORDS;

  position = ((float)(sector - call_begin) /
	      (call_end - call_begin)) * 100;

  //  printf ("\r %d%", position);
  
  position = 0;
}
