/*conf.c
*
*    Copyright 2002 Jonathan Gonzalez V. <jonathan@blueplanet.cl>
*
*    http://apolos.sourceforge.net
*
*	This program is free software; you can redistribute it and/or modify
*    it under the terms of the GNU General Public License as published by
*    the Free Software Foundation; either version 2 of the License, or
*    (at your option) any later version.
*
*    This program is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*    GNU General Public License for more details.
*
*    You should have received a copy of the GNU General Public License
*    along with this program; if not, write to the Free Software
*    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include<stdio.h>
#include<string.h>
#include<stdlib.h>

#include"../config.h"

#include"conf.h"
#include"graf.h"
#include"utils.h"
#include"callbacks.h"

#define CONFIG {"dev_cdrom", cd->cd_device}, \
{"cddb_servidor", cd->cddb->servidor}, \
{"port", cd->cddb->puerto}, \
{"auto-check-cddb", cd->cddb->autocheck}, \
{"playlist-mainwin", cd->playlist_mainwin}, \
{"rip-temp-files", rip->temp_files}, \
{"ripped-files", rip->ripped_files}, \

GtkWidget *
Entry (char *etiqueta, int largo, char *value, GtkWidget * entry)
{
  GtkWidget *table;
  GtkWidget *hbox;
  GtkWidget *label;

  hbox = gtk_hbox_new (FALSE, 0);

  table = gtk_table_new (1, 2, TRUE);

  label = gtk_label_new (etiqueta);
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 0, 1);
  gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 3);
  gtk_widget_show (label);


  if (entry == NULL)
    entry = gtk_entry_new_with_max_length (largo);
  gtk_entry_set_text (GTK_ENTRY (entry), value);
  gtk_table_attach_defaults (GTK_TABLE (table), entry, 1, 2, 0, 1);
  gtk_widget_show (entry);

  g_signal_connect (G_OBJECT (entry), "changed",
		    G_CALLBACK (Cambiar_Conf), (gpointer) value);

  gtk_box_pack_start (GTK_BOX (hbox), table, TRUE, TRUE, 0);
  gtk_widget_show (table);
  gtk_widget_show (hbox);

  return hbox;

}

void
Configuracion (gpointer data, unsigned int action, GtkWidget * widget)
{
  GtkWidget *vbox1;
  GtkWidget *label;
  GtkWidget *vbox2;
  GtkWidget *hbox1;
  GtkWidget *hbox2;
  GtkWidget *notebook1;
  GtkWidget *check;
  GtkWidget *button1;
  GtkWidget *button2;

  DatosCD *datos = (DatosCD *) data;
  Graf *graf = datos->graf;
  Datos *cd = datos->cd;
  Rip *rip = datos->rip;

  if (cd->config == TRUE)
    {
      gtk_window_present (GTK_WINDOW (graf->win_config));
    }
  else
    {

      graf->win_config = gtk_window_new (GTK_WINDOW_TOPLEVEL);
      gtk_window_set_title (GTK_WINDOW (graf->win_config),
			    _(PACKAGE " " VERSION " - Setup"));
      gtk_window_set_policy (GTK_WINDOW (graf->win_config), FALSE, FALSE, FALSE);
      g_signal_connect (G_OBJECT (graf->win_config), "destroy",
			G_CALLBACK (Dont_Save), (gpointer) datos);

      cd->config = TRUE;

      vbox1 = gtk_vbox_new (FALSE, 0);
      gtk_widget_show (vbox1);
      gtk_container_add (GTK_CONTAINER (graf->win_config), vbox1);
      gtk_container_set_border_width (GTK_CONTAINER (vbox1), 6);


      notebook1 = gtk_notebook_new ();
      gtk_widget_show (notebook1);
      gtk_box_pack_start (GTK_BOX (vbox1), notebook1, TRUE, TRUE, 0);

      /*
	From here start the General notebook
       */

      vbox2 = gtk_vbox_new (FALSE, 0);
      gtk_container_add (GTK_CONTAINER (notebook1), vbox2);

      hbox1 = Entry (_("CD-Rom device"), 20, cd->cd_device, NULL);
      gtk_box_pack_start (GTK_BOX (vbox2), hbox1, FALSE, TRUE, 0);
      gtk_widget_show (hbox1);

      hbox1 = CheckButton (_("Auto Check CDDB"), atoi(cd->cddb->autocheck));
      g_signal_connect (G_OBJECT (hbox1), "clicked",
			G_CALLBACK (Change_check_button), (gpointer) cd->cddb->autocheck);
      gtk_box_pack_start (GTK_BOX (vbox2), hbox1, FALSE, TRUE, 0);
      gtk_widget_show (hbox1);

      hbox1 = CheckButton(_("Use playlist into the main window"), atoi(cd->playlist_mainwin));
      g_signal_connect (G_OBJECT (hbox1), "clicked",
			G_CALLBACK (Change_check_button), (gpointer) cd->playlist_mainwin);
      gtk_box_pack_start (GTK_BOX (vbox2), hbox1, FALSE, TRUE, 0);
      gtk_widget_show (hbox1);
      
      label = gtk_label_new_with_mnemonic (_("_General"));
      gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1),
				  gtk_notebook_get_nth_page (GTK_NOTEBOOK
							     (notebook1), 0),
				  label);
      gtk_widget_show (label);

      gtk_widget_show (hbox1);
      gtk_widget_show (vbox2);


      /*
	From here start the CDDB notebook
       */

      vbox2 = gtk_vbox_new (FALSE, 0);
      gtk_container_add (GTK_CONTAINER (notebook1), vbox2);

      label = gtk_label_new_with_mnemonic (_("C_DDB"));
      gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1),
				  gtk_notebook_get_nth_page (GTK_NOTEBOOK
							     (notebook1), 1),
				  label);
      gtk_widget_show (label);

      cd->cddb->entry = gtk_entry_new_with_max_length (20);
      hbox1 =
	Entry (_("CDDB Server"), 20, cd->cddb->servidor, cd->cddb->entry);
      gtk_box_pack_start (GTK_BOX (vbox2), hbox1, FALSE, TRUE, 0);
      gtk_widget_show (hbox1);

      hbox1 = Entry (_("Port"), 5, cd->cddb->puerto, NULL);
      gtk_box_pack_start (GTK_BOX (vbox2), hbox1, FALSE, TRUE, 0);
      gtk_widget_show (hbox1);

      hbox1 = gtk_hbox_new (FALSE, 0);
      gtk_box_pack_start (GTK_BOX (vbox2), hbox1, FALSE, FALSE, 0);
      gtk_container_set_border_width (GTK_CONTAINER (hbox1), 4);

      check = gtk_button_new_with_mnemonic (_("_List of Public Servers"));
      g_signal_connect (G_OBJECT (check), "clicked",
			G_CALLBACK (Look_Up_Servers), (gpointer) datos);
      gtk_box_pack_start (GTK_BOX (hbox1), check, FALSE, FALSE, 0);
      gtk_widget_show (check);

      gtk_widget_show (hbox1);
      gtk_widget_show (vbox2);

      /*
	From here start the Rip notebook
       */


      vbox2 = gtk_vbox_new (FALSE, 0);
      gtk_widget_show (vbox2);
      gtk_container_add (GTK_CONTAINER (notebook1), vbox2);
      
      label = gtk_label_new_with_mnemonic (_("_Rip"));
      gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1),
				  gtk_notebook_get_nth_page (GTK_NOTEBOOK
							     (notebook1), 2),
				  label);
      gtk_widget_show (label);

      hbox1 = Entry (_("Temp Files (wav files)"), 35, rip->temp_files, NULL);
      gtk_box_pack_start (GTK_BOX (vbox2), hbox1, FALSE, TRUE, 0);
      gtk_widget_show (hbox1);

      hbox1 = Entry (_("Ripped Files"), 35, rip->ripped_files, NULL);
      gtk_box_pack_start (GTK_BOX (vbox2), hbox1, FALSE, TRUE, 0);
      gtk_widget_show (hbox1);


      /*
	Here finish all the notebooks
       */

      hbox2 = gtk_hbox_new (TRUE, 0);
      gtk_box_pack_end (GTK_BOX (vbox1), hbox2, FALSE, FALSE, 0);
      gtk_container_set_border_width (GTK_CONTAINER (hbox1), 4);
      gtk_widget_show (hbox2);

      button2 = gtk_button_new_from_stock (GTK_STOCK_OK);
      g_signal_connect (G_OBJECT (button2), "clicked",
			G_CALLBACK (Guardar_Config), (gpointer) datos);
      gtk_box_pack_start (GTK_BOX (hbox2), button2, FALSE, FALSE, 0);
      gtk_widget_show (button2);

      button1 = gtk_button_new_from_stock (GTK_STOCK_CANCEL);
      g_signal_connect (G_OBJECT (button1), "clicked",
			G_CALLBACK (Dont_Save), (gpointer) datos);
      gtk_box_pack_start (GTK_BOX (hbox2), button1, FALSE, FALSE, 0);
      gtk_widget_show (button1);

      gtk_widget_show (graf->win_config);
    }
}

void
Dont_Save (GtkWidget * widget, gpointer data)
{
  DatosCD *datos;
  Graf *graf;
  Datos *cd;
  datos = (DatosCD *) data;

  graf = datos->graf;
  cd = datos->cd;

  gtk_widget_destroy (graf->win_config);
  cd->config = FALSE;
}

void
Guardar_Config (GtkWidget * widget, gpointer data)
{
  DatosCD *datos;
  Graf *graf;
  Datos *cd;
  datos = (DatosCD *) data;

  graf = datos->graf;
  cd = datos->cd;

  Save_File (cd, datos->rip);
  gtk_widget_destroy (graf->win_config);
  cd->config = FALSE;
}

void
Save_File (Datos * cd, Rip *rip)
{
  FILE *fp;
  Config config[] = {
    CONFIG
  };

  fp = fopen (cd->config_file, "w");
	if (fp == NULL) 
	{
	  printf(_("Error Al abrir el archivo"));
	  exit(EXIT_FAILURE);
	}			
		
  fprintf (fp, "Apolos Config\n");
  fprintf (fp, "%s=%s\n", config[0].variable, config[0].var);
  fprintf (fp, "%s=%s\n", config[1].variable, config[1].var);
  fprintf (fp, "%s=%s\n", config[2].variable, config[2].var);
  fprintf (fp, "%s=%s\n", config[3].variable, config[3].var);
  fprintf (fp, "%s=%s\n", config[4].variable, config[4].var);
  fprintf (fp, "%s=%s\n", config[5].variable, config[5].var);
  fprintf (fp, "%s=%s\n", config[6].variable, config[6].var);
  fclose (fp);
}

void
config_file (Datos *cd, Rip *rip)
{
  FILE *fp;
  int i;
  int p;
  char line[256] = "\0";
  char value[256] = "\0";
  char name[256] = "\0";
  Config config[] = {
    CONFIG
  };

  sprintf (cd->config_file, "%s/.apolos", getenv ("HOME"));
  p = check_file (cd->config_file);

  if (p == FALSE)
    {
      fp = fopen (cd->config_file, "w");
		
      /* Vemos que se abra bien el archivo */
      if (fp == NULL) 
	{
	  printf (_("Error Al abrir el archivo"));
	  exit (EXIT_FAILURE);
	}			
			
      fprintf (fp, "Apolos Config\n");
      fprintf (fp, "dev_cdrom=/dev/cdrom\n");
      fprintf (fp, "cddb_servidor=freedb.freedb.org\n");
      fprintf (fp, "port=8880\n");
      fprintf (fp, "auto-check-cddb=1\n");
      fprintf (fp, "playlist-mainwin=1\n");
      fprintf (fp, "rip-temp-files=/tmp\n");
      fprintf (fp, "ripped-files=%s/\n", getenv ("HOME"));
      fclose (fp);
    }

  fp = fopen (cd->config_file, "r");
	if (fp == NULL) 
		{
		  //	printf("Error Al abrir el archivo");
			exit(EXIT_FAILURE);
		}			
		
  fgets (line, 256, fp);

  if (strcmp (line, "Apolos Config\n") != 0)
    {
      //      printf ("Archivo de configuracion erroneo\n");
      exit (0);
    }

  while (fgets (line, 256, fp))
    {
      get_value (line, value, '=');
      get_name (line, name);

      for (i = 0; i < (sizeof (config) / sizeof (config[0])); i++)
	{
	  if (strcmp (name, config[i].variable) == 0)
	    {
		strcpy (config[i].var, value);
	    }
	}
      memset (value, '\0', 256);
      memset (name, '\0', 256);
    }
  fclose (fp);
}

void
Cambiar_Conf (GtkWidget * widget, gpointer data)
{
  strcpy ((char *) data, gtk_entry_get_text (GTK_ENTRY (widget)));
}
