/*cddb.c
*
*    Copyright 2003 Jonathan Gonzalez V. <jonathan@blueplanet.cl>
*
*    http://apolos.sourceforge.net
*
*	This program is free software; you can redistribute it and/or modify
*    it under the terms of the GNU General Public License as published by
*    the Free Software Foundation; either version 2 of the License, or
*    (at your option) any later version.
*
*    This program is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*    GNU General Public License for more details.
*
*    You should have received a copy of the GNU General Public License
*    along with this program; if not, write to the Free Software
*    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include<netinet/in.h>
#include<arpa/inet.h>
#include<netdb.h>
#include<sys/types.h>
#include<sys/socket.h>
#include<errno.h>
#include<unistd.h>
#include<pthread.h>

#include<string.h>
#include<stdlib.h>
#include<stdio.h>

#include"../config.h"

#include"graf.h"
#include"cddb.h"
#include"conf.h"
#include"utils.h"

/*
  1. Code of the response
  2. Text of the code
  3. Command
  4. If terminated in .
  5. Is TRUE when the response it's Ok
 */

#define ERRORS \
{200, "OK, read/write allowed", "sign-on", FALSE, TRUE}, \
{201, "Ok, read only", "sign-on", FALSE, TRUE}, \
{432, "No connections allowed: permission denied", "sign-on", FALSE, FALSE}, \
{433, "No connections allowed: X users allowed, Y currently active", "sign-on", FALSE, FALSE}, \
{434, "No connections allowed: system load too high", "sign-on", FALSE, FALSE}, \
{200, "Handshake successful", "handshake", FALSE, TRUE}, \
{431, "Handshake not successful, closing connection", "handshake", FALSE, FALSE}, \
{402, "Already shook hands", "handshake", FALSE, TRUE}, \
{210, "Okay category list follows", "lscat", TRUE, TRUE}, \
{200, "Found exact match", "query", FALSE, TRUE}, \
{211, "Found inexact matches, list follows (until terminating marker)", "query", TRUE, TRUE}, \
{202, "No match found", "query", FALSE, FALSE}, \
{403, "Database entry is corrupt", "query", FALSE, FALSE}, \
{409, "No handshake", "query", FALSE, FALSE}, \
{210, "OK, CDDB database entry follows", "read", FALSE, FALSE}, \
{401, "Specified CDDB entry not found.", "read", FALSE, FALSE}, \
{402, "Server error.", "read", FALSE, FALSE}, \
{403, "Database entry is corrupt.", "read", FALSE, FALSE}, \
{409, "No handshake.", "read", FALSE, FALSE}, \
{210, "Ok, site information follows", "sites", TRUE, TRUE},\
{401, "No site information available.", "sites", FALSE, FALSE},\


int
Suma (int n)
{
  int ret = 0;

  while (n > 0)
    {
      ret = ret + (n % 10);
      n = n / 10;
    }

  return ret;
}

unsigned int
DiscID (Datos * cd)
{
  Tracklist *lista = cd->header;
  int discid, i, suma = 0;

  for (i = 0; i < cd->total_track; i++)
    {
      suma += Suma (lista->offset->minutos * 60 + lista->offset->sec);
      lista = lista->next;
    }

  discid = (cd->Disco->offset->minutos * 60 + cd->Disco->offset->sec) -
    (cd->header->offset->minutos * 60 + cd->header->offset->sec);

  return ((suma % 0xff) << 24 | discid << 8 | cd->total_track);
}

int
Connection (CDDB * cddb)
{
  int ret;
  struct hostent *host;
  struct sockaddr_in addr;

  cddb->socket = socket (AF_INET, SOCK_STREAM, 0);

  host = gethostbyname (cddb->servidor);
  if (host == NULL)
    {
      Error (strerror (errno), _("Get Hostname"));
      return -1;
    }
  addr.sin_family = AF_INET;
  addr.sin_port = htons (8880);
  addr.sin_addr = *((struct in_addr *) host->h_addr);
  memset (&(addr.sin_zero), '\0', 8);

  ret = connect (cddb->socket, (struct sockaddr *) &addr, sizeof (struct sockaddr));
  if(ret == -1)
    {
      Error (strerror (errno), _("Connect"));
      return -1;
    }

  Recivir_Inicial (cddb);

  return atoi (cddb->codigo);
}

void
Recivir_Inicial (CDDB * cddb)
{
  int recvd;

  memset (cddb->buf, '\0', 2048);

  recvd = recv (cddb->socket, cddb->buf, 2048, 0);
  if (recvd == -1)
    perror ("recv");
  else
    {
      cddb->codigo = (char *) calloc (3, sizeof (char *));
      strncpy (cddb->codigo, cddb->buf, 3);
    }
}

void
Look_Up_CDDB (GtkWidget * widget, gpointer data)
{
  //  pthread_t threadp;
  //pthread_attr_t thread_attr;
  char *buf;
  int exist;
  DatosCD *datos;
  Datos *cd;
  Graf *graf;
  datos = (DatosCD *) data;

  cd = datos->cd;
  graf = datos->graf;

  MSG_to_Statusbar (graf, _("Checking CDDB..."));
  
  if (cd->existcd == FALSE)
    {
      Error (_("No Disc"), _("Checking CDDB"));
      remove_MSG_Statusbar (graf);
      return;
    }
  if (cd->cddb->socket != -1)
    return;
  
  buf = (char *) calloc (256, sizeof (char *));
  snprintf (buf, 256, "%s/.cddb/%08x", getenv ("HOME"), cd->discid);
  
  exist = check_file (buf);
  if (exist == TRUE)
    {
      remove_MSG_Statusbar (graf);
      MSG_to_Statusbar (graf, _("Reading File"));
      Read_File (datos, buf);
      MSG_to_Statusbar (graf, _("Done."));
    }
  else
    pthread_create (&(cd->cddb_thread), NULL, (void *)Check_CDDB, (void *)datos);
  
  free (buf);
}

void * 
Check_CDDB (void *data)
{
  int codigo, error;
  char buf[256];
  DatosCD *datos;
   Datos *cd;
  Graf *graf;
  datos = (DatosCD *) data;

  cd = datos->cd;
  graf = datos->graf;

  g_snprintf (buf, 256, _("Connecting with %s ..."), cd->cddb->servidor);
  MSG_to_Statusbar (graf, buf);

  codigo = Connection (cd->cddb);
  if (codigo == -1)
    {
      MSG_to_Statusbar (graf, _("Done."));
      // Error (strerror (errno), _("Connection"));
      close(cd->cddb->socket);
      cd->cddb_ok = FALSE;
      cd->cddb->socket = -1;
      pthread_exit (NULL);
    }
  else
    {
      error = Find ("sign-on", codigo, graf);

      codigo = Sign_on (cd->cddb);
      error = Find ("handshake", codigo, graf);

      codigo = Query (datos);
      error = Find ("query", codigo, graf);
      Make_Disc (datos, codigo, cd->cddb->buf);

      codigo = Read (cd);
      error = Find ("read", codigo, graf);
      if (codigo == 210)
	{
	  if (Write_File (cd) == 0)
	    {
	      snprintf (buf, 256, "%s/.cddb/%08x", getenv ("HOME"),
			cd->discid);
	      Read_File (datos, buf);	     
	    }
	  else
	    {
	      snprintf (buf, 256, 
			_("You have to create .cddb directory\n on your home"));
	      Error (buf, "Check CDDB");
	      cd->cddb_ok = FALSE;
	    }
	}
    }


  MSG_to_Statusbar(graf, _("Done."));

  close (cd->cddb->socket);
  cd->cddb->socket = -1;

  pthread_exit (0);
}

int
Find (char *accion, int codigo, Graf *graf)
{
  int i;
  char buf[256];
  Errors errors[] = {
    ERRORS
  };

  for (i = 0; i < sizeof (errors) / sizeof (errors[0]); i++)
    {
      if (strcmp (accion, errors[i].accion) == 0)
	if (errors[i].number == codigo)
	  {
	    snprintf (buf, 256, _("CDDB: %s"), errors[i].desc);
	    MSG_to_Statusbar (graf, buf);
	    return 0;
	  }
    }
  return -1;
}

int
Send_Request (CDDB * cddb, char *datos)
{
  int enviados;

  while (1)
    {
      enviados = send (cddb->socket, datos, strlen (datos), 0);
      if (enviados == strlen (datos))
	break;

      if (enviados == -1)
	{
	  perror (_("Send"));
	  break;
	}
    }
  return enviados;
}

int
Sign_on (CDDB * cddb)
{
  char *user = getenv ("USER");
  char *host = getenv ("HOST");
  char req[256] = "\0";

  if (!host)
    host = "localhost";

  snprintf (req, 256, "cddb hello %s %s %s %s\n", user, host, PACKAGE,
	    VERSION);

  Send_Request (cddb, req);

  Recivir_Inicial (cddb);

  return atoi (cddb->codigo);
}

int
Query (DatosCD * datos)
{
  Datos *cd = datos->cd;
  char req[256] = "\0";
  char als[10];
  
  snprintf (req, 256, "cddb query %08x %d ", cd->discid,
	    cd->total_track);

  do
    {
      snprintf (als, 10, "%d ", cd->tracklist->start->frame);
      strcat (req, als);
      cd->tracklist = cd->tracklist->next;
    }
  while (cd->tracklist != cd->header);

  snprintf (als, 10, "%d\n",
	    cd->Disco->time->minutos * 60 + cd->Disco->time->sec);
  strcat (req, als);

  Send_Request (cd->cddb, req);

  Recivir_Inicial (cd->cddb);

  return atoi (cd->cddb->codigo);
}

void
Make_Disc (DatosCD * datos, int codigo, char buf[])
{
  Datos *cd = datos->cd;
  int i, ult, o = 0;

  if (codigo == 200)
    {
      cd->cddb->match = EXACT_MATCH;

      for (i = 0; buf[i + 4] != ' '; i++)
	if (i == 0)
	  cd->Disco->estilo[i] = buf[i + 4];
	else
	  cd->Disco->estilo[i] = buf[i + 4];

      ult = i + 4 + 10;

      for (i = 0; buf[ult + i] != '/'; i++)
	cd->Disco->artista->texto[i] = buf[ult + i];

      cd->Disco->artista->texto[i - 1] = '\0';

      ult = ult + i + 2;

      for (i = 0; buf[ult + i] != '\r'; i++)
	//	cd->Disco->titulo[i] = buf[ult + i];
	cd->Disco->titulo->texto[i] = buf[ult + i];
    }
  else if (codigo == 600)
    {
      cd->cddb->match = EXACT_MATCH;

      for (i = 0; buf[i] != '/'; i++)
	cd->Disco->artista->texto[i] = buf[i];

      ult = i + 2;

      for (i = 0; buf[ult + i] != '\n'; i++)
	//	cd->Disco->titulo[i] = buf[ult + i];
	cd->Disco->titulo->texto[i] = buf[ult + i];
    }
  else if (codigo == 211)
    {
      cd->cddb->match = INEXACT_MATCH;

      for (i = 0; buf[i] != '\n'; i++);
      ult = i + 1;

      for (i = ult; buf[i] != ' '; i++)
	cd->Disco->estilo[o++] = buf[i];
      ult = i + 1;

      cd->cddb->otherid = (char *) calloc (10, sizeof (char *));
      o = 0;
      for (i = ult; buf[i] != ' '; i++)
	cd->cddb->otherid[o++] = buf[i];

      ult = i + 1;

      for (i = 0; buf[ult + i] != '/'; i++)
	cd->Disco->artista->texto[i] = buf[ult + i];
      cd->Disco->artista->texto[i - 1] = '\0';

      ult = ult + i + 2;

      for (i = 0; buf[ult + i] != '\r'; i++)
	//	cd->Disco->titulo[i] = buf[ult + i];

	cd->Disco->titulo->texto[i] = buf[ult + i];
    }

  cd->Disco->titulo->largo = strlen (cd->Disco->titulo->texto);

  cd->Disco->artista->largo = strlen (cd->Disco->artista->texto);
  /*
  cd->Disco->titulo->texto = g_convert (cd->Disco->titulo->texto, cd->Disco->titulo->largo, "UTF-8",
					"ISO-8859-1", NULL, NULL, NULL);
  gtk_label_set_text (GTK_LABEL (graf->label_title), cd->Disco->titulo->texto);

  cd->Disco->artista->texto = g_convert (cd->Disco->artista->texto, cd->Disco->artista->largo, "UTF-8",
					 "ISO-8859-1", NULL, NULL, NULL);
    gtk_label_set_text (GTK_LABEL (graf->label_artista), cd->Disco->artista->texto);
*/
}

int
Read (Datos * cd)
{
  char buf[256];

  if (cd->cddb->match == EXACT_MATCH)
    snprintf (buf, 256, "cddb read %s %08x\n", cd->Disco->estilo,
	      cd->discid);
  else if (cd->cddb->match == INEXACT_MATCH)
    snprintf (buf, 256, "cddb read %s %s\n", cd->Disco->estilo,
	      cd->cddb->otherid);

  Send_Request (cd->cddb, buf);

  Recivir_Inicial (cd->cddb);

  return atoi (cd->cddb->codigo);
}

int
Write_File (Datos * cd)
{
  FILE *fp;
  char *file = (char *) calloc (256, sizeof (char *));
  int i, n = 0;

  snprintf (file, 256, "%s/.cddb", getenv ("HOME"));

  if (check_dictory (file) == FALSE)
    return 1;

  snprintf (file, 256, "%s/.cddb/%08x", getenv ("HOME"), cd->discid);

  if (check_file (file) == FALSE)
    {
      fp = fopen (file, "w");

      for (i = 0; cd->cddb->buf[i] != '\0'; i++)
	{
	  if (n != 0)
	    fprintf (fp, "%c", cd->cddb->buf[i]);
	  if (cd->cddb->buf[i] == '\n')
	    n = 1;
	}
      fclose (fp);
    }

  free (file);

  return 0;
}

void
Read_File (DatosCD * datos, char *file)
{
  FILE *fp;
  char buf[256] = "\0";
  char value[100] = "\0";
  char macro[11] = "\0";
  char track[2] = "\0";
  Tracklist *tracklist;
  Datos *cd = datos->cd;

  fp = fopen (file, "r");

  while (fgets (buf, 256, fp))
    {
      if (buf[0] == '#')
	;
      else
	{
	  get_value (buf, value, '=');
	  get_name (buf, macro);
	  strcat (macro, "\n");
	  if (strcmp (macro, "DTITLE\n") == 0)
	    {
	      strcat (value, "\n");
	      Make_Disc (datos, 600, value);
	    }

	  if (macro[0] == 'T')
	    {
	      get_value (macro, track, 'E');
	      tracklist = Find_Track (cd, atoi (track) + 1);
	      strcpy (tracklist->titulo->texto, value);

	      tracklist->titulo->largo = strlen (tracklist->titulo->texto);
	      tracklist->titulo->texto = g_convert (tracklist->titulo->texto, 
						    tracklist->titulo->largo, "UTF-8",
						    "ISO-8859-1", NULL, NULL, NULL);
	      tracklist->artista->largo = strlen (cd->Disco->artista->texto);
	      tracklist->artista->texto = g_convert (cd->Disco->artista->texto,
						    cd->Disco->artista->largo, "UTF-8",
						    "ISO-8859-1", NULL, NULL, NULL);
	    }

	  memset (macro, '\0', 11);
	  memset (value, '\0', 100);
	}

    }

  if (cd->lista == TRUE)
    Make_Titles (datos);

  cd->cddb_ok = TRUE;

  change_main_title (datos->graf, cd);

  fclose (fp);
}

void
Make_Titles (DatosCD * datos)
{
  Graf *graf = datos->graf;
  Datos *cd = datos->cd;
  GtkTreeIter iter;
  char *row[3];

  gtk_tree_model_get_iter_first (GTK_TREE_MODEL (graf->treestore), &iter);
  do
    {
      row[0] = (char *) calloc (5, sizeof (char *));
      row[1] = (char *) calloc (100, sizeof (char *));
      row[2] = (char *) calloc (8, sizeof (char *));

      snprintf (row[0], 5, "%02d", cd->tracklist->track);
      snprintf (row[1], 100, "%s", cd->tracklist->titulo->texto);
      snprintf (row[2], 8, "%02d:%02d", cd->tracklist->time->minutos,
		cd->tracklist->time->sec);

      gtk_tree_store_set (graf->treestore, &iter,
			  0, row[0], 1, row[1], 2, row[2], -1);

      free (row[0]);
      free (row[1]);
      free (row[2]);

      gtk_tree_model_iter_next (GTK_TREE_MODEL (graf->treestore), &iter);

      cd->tracklist = cd->tracklist->next;
    }
  while (cd->tracklist != cd->header);

}

void *
Servers (void * data)
{
  int codigo, error;
  char buf[256];
  char *sites;
  int i, site = 0, n = 0;
  int space = 0;
  DatosCD *datos = (DatosCD *) data;
  CDDB *cddb = datos->cd->cddb;
  Graf *graf = datos->graf;
  Server *Sites = cddb->Servers;
  Server *nuevo;

  sites = (char *) malloc (2048);
  memset (sites, '\0', 2048);


  Sites->back = NULL;
  Sites->host = (char *) calloc (20, sizeof (char *));
  Sites->port = (char *) calloc (4, sizeof (char *));
  Sites->latitud = (char *) calloc (8, sizeof (char *));
  Sites->longitud = (char *) calloc (8, sizeof (char *));
  Sites->description = (char *) calloc (40, sizeof (char *));
  Sites->next = NULL;

  g_snprintf (buf, 256, _("Connecting with %s ..."), cddb->servidor);
  MSG_to_Statusbar (graf, buf);

  codigo = Connection (cddb);
  if (codigo == -1)
    pthread_exit(0);
  error = Find ("sign-on", codigo, graf);

  codigo = Sign_on (cddb);
  error = Find ("handshake", codigo, graf);

  codigo = Servers_Request (cddb);
  error = Find ("sites", codigo, graf);

  for (i = 0; i < sizeof (cddb->buf); i++)
    {
      if (n != 0)
	sites[site++] = cddb->buf[i];
      if (cddb->buf[i] == '\n')
	n = 1;
    }
  n = 0;

  for (i = 0; sites[i] != '\0'; i++)
    {
      if (sites[i] == ' ')
	{
	  space++;
	  if (space <= 4)
	    n = 0;
	}

      if (space == 0 && sites[i] != ' ')
	Sites->host[n++] = sites[i];
      else if (space == 1 && sites[i] != ' ')
	Sites->port[n++] = sites[i];
      else if (space == 2 && sites[i] != ' ')
	Sites->latitud[n++] = sites[i];
      else if (space == 3 && sites[i] != ' ')
	Sites->longitud[n++] = sites[i];
      else if (space >= 4 && sites[i] != '\r' && sites[i] != '\n')
	Sites->description[n++] = sites[i];

      if (sites[i] == '\n')
	{
	  space = 0;
	  n = 0;
	  site++;

	  if (sites[i + 1] == '.')
	    break;

	  nuevo = (Server *) malloc (sizeof (Server));
	  Sites->next = nuevo;
	  nuevo->back = Sites;
	  nuevo->host = (char *) calloc (20, sizeof (char *));
	  nuevo->port = (char *) calloc (4, sizeof (char *));
	  nuevo->latitud = (char *) calloc (8, sizeof (char *));
	  nuevo->longitud = (char *) calloc (8, sizeof (char *));
	  nuevo->description = (char *) calloc (40, sizeof (char *));
	  nuevo->next = NULL;

	  Sites = nuevo;

	}
    }

  Sites = cddb->header;

  close (cddb->socket);

  pthread_exit(0);
}

int
Servers_Request (CDDB * cddb)
{
  char buf[256];

  snprintf (buf, 256, "sites\n");

  Send_Request (cddb, buf);

  Recivir_Inicial (cddb);

  return atoi (cddb->codigo);
}
