/*
  AntiRight
  (c) 2002-2007 Jeffrey Bedard
  antiright@gmail.com

  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifdef XSH_DECORATE
#include "xshell.h"

#define GRADIENT_DELTA 16



static void
cleanup(Display * display, GC gc)
{
	XFreeGC(display, gc);
}

#define SET_COLOR XSH_SET_COLOR

static void
draw_frame(Display * dpy, Window win, GC gc, Bool outset,
	XWindowAttributes geometry)
{
	short val;

	val=outset?255:0;
	SET_COLOR(dpy, gc, val, val, val);
	/* top */
	XDrawLine(dpy, win, gc, 0, 0, geometry.width, 0);
	/* left */
	XDrawLine(dpy, win, gc, 0, 0, 0, geometry.height);

	val=!outset?255:0;
	SET_COLOR(dpy, gc, val, val, val);
	/* bottom */
	XDrawLine(dpy, win, gc, 0, geometry.height-1, 
		geometry.width, geometry.height-1);
	/* right */
	XDrawLine(dpy, win, gc, geometry.width-1, 0, 
		geometry.width-1, geometry.height);

#ifdef XSH_USE_INDICATOR
	SET_COLOR(dpy, gc, 0xae, 0xff, 0xc3);
	XFillArc(dpy, win, gc, geometry.width-8,
		geometry.height/5, 4, 8, 0, 360*64);
	SET_COLOR(dpy, gc, (0xae)/2, (0xb2)/2, (0xc3)/2);
	XDrawArc(dpy, win, gc, geometry.width-8,
		geometry.height/5, 4, 8, 0, 360*64);
	SET_COLOR(dpy, gc, (0xae)/3, (0xb2)/3, (0xc3)/3);
	XDrawArc(dpy, win, gc, geometry.width-8,
		geometry.height/5, 5, 9, 0, 360*64);
#endif /* XSH_USE_INDICATOR */
}

#ifdef XSH_USE_GRADIENT
static void
draw_gradient(Display * display, Window  window, GC gc,
	XWindowAttributes * geometry, int order)
{
	unsigned int counter;

	for(counter = 0; counter++<(unsigned int)geometry->height;) 
	{
		unsigned int delta;
		int y;
		
		delta=-order*counter*4;
		SET_COLOR(display, gc,
			(0xae)+delta*(order),
			(0xb2)+delta*(order),
			(0xc3)+delta*(order));
		/* Sunken or raised determined by Y start.  */
		y=(order >= 0) ? counter : geometry->height-counter;
		/* Draw gradient portion.  */
		XDrawLine(display, window, gc, 
			0, y, geometry->width, y);
	}
}

void
xsh_setup_gradients(XShell * xsh)
{
}

#endif /* XSH_USE_GRADIENT */

void
xsh_decorate(XWidget * widget, int order)
{
	GC gc;
	XShell * xsh;
	Display * display;
	Window window;

	xsh=xsh_get_XShell_for_widget(widget);
	gc=XSH_SETUP_GC(display=xsh->gui.display, window=widget->window);

	/* Draw decoration */
	{
		XWindowAttributes geometry;

		XGetWindowAttributes(display, window, &geometry);
#ifdef XSH_USE_GRADIENT
		draw_gradient(display, window, gc, &geometry, -order);
#else /* not XSH_USE_GRADIENT */
		SET_COLOR(display, gc, (0xae)+4*-order, (0xb2)+4*-order, (0xc3)+4*-order);
		XFillRectangle(display, window, gc, 
			0, 0, geometry.width, geometry.height);
#endif /* XSH_USE_GRADIENT */
		if(order != 0)
			draw_frame(display, window, gc, order!=1, geometry);
	}
	/* Free GC data.  */
	cleanup(display, gc);
}

#endif /* XSH_DECORATE */


