/*
  AntiRight
  (c) 2002-2007 Jeffrey Bedard
  antiright@gmail.com

  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "library.h"

struct ARTupleVector *
ar_new_ARTupleVector()
{
	struct ARTupleVector * vector;

	vector=g_malloc(sizeof(struct ARTupleVector));
	vector->__hash=g_hash_table_new(&g_str_hash, &g_str_equal);
	vector->add=&ar_add_ARTupleVector;
	vector->find=&ar_find_ARTupleVector;
	vector->delete=&ar_delete_ARTupleVector;

	return vector;
}

void
ar_delete_ARTupleVector(struct ARTupleVector * vector)
{
	g_hash_table_destroy(vector->__hash);
	g_free(vector);
}

void
ar_add_ARTupleVector(struct ARTupleVector * vector,
		     const gchar * key, const gchar * value)
{
	g_hash_table_insert(vector->__hash, (gpointer)key, (gpointer)value);
}

const gchar *
ar_find_ARTupleVector(struct ARTupleVector * vector,
		      const gchar * term)
{
	return (const gchar *)g_hash_table_lookup(vector->__hash, 
						  (gconstpointer)term);
}

