/*
  AntiRight
  (c) 2002-2006 Jeffrey Bedard
  antiright@gmail.com

  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "gtkshell.h"

static void
add_updater(GSH * gsh, const gint argc, gint * counter, 
	const gchar ** argv, void (*add_func)(GSH *, const gchar *))
{
	GSH_COUNT(argc, counter);
	add_func(gsh, argv[*counter]);
}

#define UADD(type) \
	add_updater(gsh, argc, counter, argv, &gsh_add_updated_##type)

void
gsh_handle_updated_arguments(GSH * gsh, const gint argc,
			     const gchar **argv, gint *counter)
{
#ifdef DEBUG
	ARPASSERT(gsh);
#endif /* DEBUG */

	g_assert(strlen(argv[(*counter)]) > 2);
	switch (argv[(*counter)][3])
	{
	case 'l':
		UADD(label);
		break;
	case 'p':
		UADD(progress);
		break;
	}
}
