/*
  AntiRight
  (c) 2002-2007 Jeffrey Bedard
  antiright@gmail.com

  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, 
  Boston, MA  02110-1301  USA
*/

#include "gtkshell.h"

void
gsh_handle_terminal_options(GSH * gsh, const gint argc, 
			    const gchar ** argv, gint *counter)
{
#ifndef DEBUG
	UNUSED(argc);
#endif /* DEBUG */
	/* Handle -ot tertiary options.  */
	switch(argv[(*counter)][3])
		{
#define GSHT gsh->terminal
#define GSHTD GSHT->dimensions
		case 'f': /* Set font for terminal widget.  */
			GSH_COUNT(argc, counter);
			GSHT->font=(gchar *)argv[*counter];
			break;
		case 'h': /* Set terminal widget height.  */
			GSH_COUNT(argc, counter);
			GSHTD.height=atoi(argv[*counter]);
			break;
		case 'T': /* Set not transparent.  (Default) */
			GSH_UNSET(GSH_TERM_TRANSPARENT);
			break;
		case 't': /* Set transparent.  */
			GSH_SET(GSH_TERM_TRANSPARENT);
			break;
		case 'w': /* Set terminal widget width.  */
			GSH_COUNT(argc, counter);
			GSHTD.width=atoi(argv[*counter]);
			break;
		default: /* Error message.  */
			ARWARN("invalid tertiary terminal option");
		}
}
