/*
  AntiRight
  (c) 2002-2007 Jeffrey Bedard
  antiright@gmail.com

  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "gtkshell.h"

/* GTK Scrolled Window Set */
#define GSWS(item, window, ...)\
	gtk_scrolled_window_set_##item(GTK_SCROLLED_WINDOW(window),\
		__VA_ARGS__)

static void
set_scrolled_window_options(GtkWidget * win)
{
#define GSWSW(item, ...) GSWS(item, win, __VA_ARGS__)
	GSWSW(shadow_type, GTK_SHADOW_OUT);
/* Shortened name.  */
#define GTKPA GTK_POLICY_AUTOMATIC
	GSWSW(policy, GTKPA, GTKPA);
}

static void
setup_scrolled_window_containers(GtkWidget * scrolled_window,
		GtkWidget * window, GtkWidget * hrow)
{
	GSHCA(window, scrolled_window);
	/* Add the main row manager to the scrolled window.  */
	gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(
		scrolled_window), hrow);
}

static void
gsh_setup_scrolled_window(struct GSH * gsh)
{
	GtkWidget * scrolled_window;
	
	scrolled_window=gsh->widgets.scrolled_window
		=gtk_scrolled_window_new(NULL, NULL);
	set_scrolled_window_options(gsh->widgets.scrolled_window);
	setup_scrolled_window_containers(scrolled_window, gsh->widgets.window,
			gsh->rows->h);
	gtk_widget_show(scrolled_window);
}

static void
setup_framed_containers(GtkWidget * frame, GtkWidget * window, 
	GtkWidget * hrow)
{
	GSHCA(window, frame);
	GSHCA(frame, hrow);
}

static void
setup_framed(struct GSH * gsh)
{
	GtkWidget * frame;

	frame = gtk_frame_new(NULL);
	setup_framed_containers(frame, gsh->widgets.window, gsh->rows->h);
	gtk_widget_show(frame);
}

void
gsh_setup_containers(struct GSH * gsh)
{
	gtk_widget_show(gsh->rows->h = gtk_hbox_new(FALSE, 2));
	$(gsh->rows, new);
}

#define GWA gsh->widgets.app

static void
setup_app_mode_frame(struct GSH * gsh)
{
	gtk_container_add(GTK_CONTAINER(GWA.frame), 
		gsh->rows->h); 
	gsh->rows->h=GWA.row;
}

void
gsh_setup_base_container(struct GSH * gsh)
{
	if(GWA.frame)
		setup_app_mode_frame(gsh);
	if (GSH_FLAG(GSH_SCROLL))
		gsh_setup_scrolled_window(gsh);
	else if (!GSH_FLAG(GSH_NO_BASE_FRAME))
		setup_framed(gsh);
	else
		GSHCA(gsh->widgets.window, gsh->rows->h);
}

