/*
  AntiRight
  (c) 2006-2007 Jeffrey Bedard
  antiright@gmail.com

  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, 
  Boston, MA  02110-1301  USA
*/

#include "gtkshell.h"

#define GW gsh->widgets
#define GWA GW.app

static void
setup_app_mode_status_bar(struct GSH * gsh)
{
	GSH_SHOW_CREATE(GWA.status, statusbar);
	GSHCA_TIGHT(GWA.row, GWA.status);
}

static void
setup_app_mode_toolbar(GSH * gsh)
{
	GSH_SHOW_CREATE(GWA.toolbar, toolbar);
	GSHCA_TIGHT(GWA.row, GWA.toolbar);
}

static void
setup_app_mode_frame(GSH * gsh)
{
	GSH_SHOW_CREATE(GWA.frame, frame, NULL);
	GSHCA(GWA.row, GWA.frame);
}

void
gsh_setup_app_mode(struct GSH * gsh)
{
	GSH_SHOW_CREATE(GWA.row, vbox, FALSE, 1);
	/* Add menu bar to application column.  */
	GSHCA_TIGHT(GWA.row, GWA.menubar);
	setup_app_mode_toolbar(gsh);
	setup_app_mode_frame(gsh);
	setup_app_mode_status_bar(gsh);
}



