#!/bin/sh

#    AntiRight (c) 2002-2007 Jeffrey Bedard antiright@gmail.com

#    This file is part of AntiRight.

#     AntiRight is free software; you can redistribute it and/or
#     modify it under the terms of the GNU General Public License as
#     published by the Free Software Foundation; either version 2 of
#     the License, or (at your option) any later version.  AntiRight
#     is distributed in the hope that it will be useful, but WITHOUT
#     ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#     GNU General Public License for more details.  You should have
#     received a copy of the GNU General Public License along with
#     AntiRight; if not, write to the Free Software Foundation, Inc.,
#     51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA



if [ "$1" = "--hostload" ]; then
LOAD="$(uptime | tr ' ' '\n' | awk -F, 'BEGIN{is_load=0}\
	/averages/{is_load=1} {{if((is_load>0)&&(++is_load > 2))\
	{print($1); exit}}}')"
	if [ "$2" = "-l" ]; then
		echo $LOAD
	else
		SCALE="$(echo $LOAD | cut -d. -f1)"
		echo "scale=2; $LOAD/($SCALE+1)" | bc -l
	fi
else
	nice -n 20 gtkshell -al "$(hostname)"\
		-aul "echo -n 'Load:  ';\
			ACE -A Hack local_loads --hostload -l"\
		-aup "ACE -A Hack local_loads --hostload"
fi
