/*
  AntiRight
  (c) 2002-2007 Jeffrey Bedard
  antiright@gmail.com

  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "library.h"

void
ar_delete_ARObject(struct ARObject * this)
{
	g_free(this->data);
	g_free(this);
}

void
ar_set_data_ARObject(struct ARObject * this, gpointer data)
{
	this->__data=data;
}

gpointer
ar_get_data_ARObject(struct ARObject * this)
{
	return this->__data;
}

struct ARObject *
ar_new_ARObject()
{
	struct ARObject * object;

	object=xmalloc(sizeof(struct ARObject));
	object->__data=NULL;
	object->delete=&ar_delete_ARObject;
	object->set_data=&ar_set_data_ARObject;
	object->get_data=&ar_get_data_ARObject;
}

struct ARVector *
ar_new_ARVector()
{
	struct ARVector * vector;

	vector=g_malloc(sizeof(struct ARVector));
	vector->__data=NULL;
	vector->__elements=0;
	vector->add=&ar_ARVector_add;
	/*vector->find=&ar_ARTupleVector_find;*/

	return vector;
}

void
ar_delete_ARVector(struct ARTupleVector * vector)
{
	struct ARObject * object;
	while(vector->elements > 1)
		if((object=vector->__data[(--(vector->__elements))-1]));
			ARMETHOD(object, delete);
	g_free(vector);
}

void
ar_ARVector_add(struct ARVector * vector, struct ARObject * object)
{
	if(++(vector->__elements) == vector->__size)
		vector->__data=realloc(vector->__data, (vector->__size*=2)
			               * sizeof(struct ARObject *));
	vector->data[vector->__elements-1]=object;
}

const gchar *
ar_ARVector_find(struct ARTupleVector * vector,
		      gchar * term)
{
	guint i;
#ifdef DEBUG
	ARPASSERT(vector);
	ARPASSERT(vector->data);
#endif /* DEBUG */
	for(i=0; i < vector->elements; i++)
		if(!strcmp(vector->data[i]->key, term))
			return vector->data[i]->value;
	/* TERM not found.  */
	return NULL;
}

