/*
  AntiRight
  (c) 2002-2007 Jeffrey Bedard
  antiright@gmail.com

  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef AR_TUPLE_H
#define AR_TUPLE_H

struct ARTupleVector
{
	GHashTable * __hash;
	void (*add)(struct ARTupleVector *, const gchar *, const gchar *);
	const gchar * (*find)(struct ARTupleVector *, const gchar *);
	void (*delete)(struct ARTupleVector *);
};

struct ARTupleVector *
ar_new_ARTupleVector();

void
ar_delete_ARTupleVector(struct ARTupleVector * vector);

void
ar_add_ARTupleVector(struct ARTupleVector * vector,
		     const gchar * key, const gchar * value);

const gchar *
ar_find_ARTupleVector(struct ARTupleVector * vector,
		      const gchar * term);

#endif /* AR_TUPLE_H */

