/*
  AntiRight
  (c) 2002-2006 Jeffrey Bedard
  antiright@gmail.com

  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "gtkshell.h"

/* This ensures that the result string is not empty, avoiding
 * certain formatting problems.
 * Otherwise, a GTK warning and termination occurs.  */

#define CHECK_RESULTS(results) \
{\
	if (results[0] == '\0')\
	{\
		g_free(results);\
		results=g_strdup("(empty)");\
	}\
}

static void
gsh_update_label(const gchar *command, gpointer widget)
{
	gchar *results;

#ifdef DEBUG
	ARBUG("gsh_update_label()");

	ARPASSERT(command);
	ARPASSERT(widget);
#endif	/* DEBUG */
	results=antiright_pipe_read(command);
	CHECK_RESULTS(results);
	if(GTK_IS_LABEL(widget))
		gtk_label_set_text(GTK_LABEL(widget), results);
	else if(GTK_IS_STATUSBAR(widget))
		gtk_statusbar_push(GTK_STATUSBAR(widget),
			gtk_statusbar_get_context_id(GTK_STATUSBAR(widget),
			"updater"), results);
	g_free(results);
}

void
gsh_add_updated_label(struct GSH * gsh, const gchar *command)
{
#define GWA gsh->widgets.app
	GtkWidget * status = GWA.status;
#ifdef DEBUG
	g_message("gsh_add_updated_label()");
	ARPASSERT(gsh);
	ARPASSERT(command);
#endif /* DEBUG */
	$(gsh->update, add, ARNEW(gsh, GSHUpdatedWidget, &gsh_update_label, 
		command, (GSH_FLAG(GSH_APP_MODE) && status)
		? status : gsh_add_label(gsh, (char *)command)));
	GSH_UNSET(GSH_APP_MODE);
	/* Prevent two updaters from being 
	   assigned to the status bar label.  */
	GWA.status=NULL;
}
