/*
  AntiRight
  (c) 2007 Jeffrey Bedard
  antiright@gmail.com

  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "gtkshell.h"

static void
gsh_GSHRows_new(struct GSHRows * this)
{
	gtk_container_add(GTK_CONTAINER(this->h), 
		this->v=gtk_vbox_new(FALSE, 2));
	gtk_widget_show(this->v);
	this->current = 1;
}

static void
gsh_GSHRows_check(struct GSHRows * this)
{
	if(this->current > this->total)
		$(this, new);
}

static void
gsh_delete_GSHRows(struct GSHRows * rows)
{
	g_free(rows);
}

#define SETUP_METHODS(rows)\
{\
	rows->delete=&gsh_delete_GSHRows;\
	rows->new=&gsh_GSHRows_new;\
	rows->check=&gsh_GSHRows_check;\
}

/* Use an arbitrary, though reasonable, initial number of rows.  */
#define SETUP_MEMBER_FIELDS(rows)\
{\
	rows->current=1;\
	rows->total=8;\
}

#define SETUP_GSHROWS(rows)\
{\
	SETUP_MEMBER_FIELDS(rows);\
	SETUP_METHODS(rows);\
}

struct GSHRows *
gsh_new_GSHRows()
{
	struct GSHRows * rows;

	rows = xmalloc(sizeof(struct GSHRows));
	SETUP_GSHROWS(rows);

	return rows;
}

static void
gsh_manage_generic(struct GSH * gsh, GtkWidget *widget)
{
	gtk_widget_show(widget);
	gsh->rows->current++;
	gsh->widgets.last_managed=widget;
}

static gboolean
test_manage_menu_item(GtkWidget * container, GtkWidget * widget)
{
	if(GTK_IS_MENU(container) || GTK_IS_MENU_BAR(container)
	   || GTK_IS_MENU_ITEM(container))
	{
		gtk_menu_shell_append(GTK_MENU_SHELL(container), widget);
		return TRUE;
	}
	else
		return FALSE;
}

static void
manage_normal(struct GSH * gsh, GtkWidget * widget)
{
	if(test_manage_menu_item(gsh->rows->v, widget))
		return;
	$(gsh->rows, check);
	gtk_container_add(GTK_CONTAINER(gsh->rows->v), widget);
	gsh_manage_generic(gsh, widget);
}

#define GR gsh->rows
#define CONTAINER GR->v
#define TEST_MANAGE_UNEXPANDED(gsh)\
	(GSH_FLAG(GSH_NO_EXPAND) &&(GR->total != 1)\
	&& !GTK_IS_MENU(CONTAINER) && !GTK_IS_MENU_BAR(CONTAINER)\
	&& !GTK_IS_MENU_ITEM(CONTAINER))


static void
manage_unexpanded(struct GSH * gsh, GtkWidget * widget)
{
	$(gsh->rows, check);
	gtk_box_pack_start(GTK_BOX(gsh->rows->v), widget,
			   FALSE, FALSE, 0);
	gsh_manage_generic(gsh, widget);
}

void
gsh_manage(struct GSH * gsh, GtkWidget *widget)
{
	if(GSH_FLAG(GSH_PANE_NEXT))
		gsh_pane_previous(gsh, widget);
	else if(TEST_MANAGE_UNEXPANDED(gsh))
		manage_unexpanded(gsh, widget);
	else
		manage_normal(gsh, widget);
}

