/*
  AntiRight
  (c) 2007 Jeffrey Bedard
  antiright@gmail.com

  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "gtkshell.h"

struct GDLEnvironment * gsh_guidl_env=NULL;

#define EDEL(member) ARDELETE(env->member)

static void
gsh_delete_GDLEnvironment(struct GDLEnvironment * env)
{
	EDEL(dictionaries);
	EDEL(args);
}

#define APPEND_ARG(env, arg) $(env->args, add, arg)

static void
gsh_GDLEnvironment_add(struct GDLEnvironment * env, 
		       const gchar * switches, gchar * argument)
{
	/* A command base argument (for command line 
   	   switch translation) is required.  */	
	if(switches)
	{
#ifdef DEBUG
	ARPASSERT(env);
#endif /* DEBUG */
		APPEND_ARG(env, switches);
		if(argument)
		{
			APPEND_ARG(env, argument);
			g_free(argument);
		}
	}
}

#define CONSTRUCT_MEMBER_CLASSES(env)\
{\
	env->args=ARNEW(ar, ARArguments);\
	env->dictionaries=ARNEW(gsh, GDLDictionaries);\
}

#define ASSIGN_METHODS(env)\
{\
	env->delete=&gsh_delete_GDLEnvironment;\
	env->add=&gsh_GDLEnvironment_add;\
}

#define SETUP_GDLENVIRONMENT(env)\
{\
	CONSTRUCT_MEMBER_CLASSES(env);\
	ASSIGN_METHODS(env);\
}

struct GDLEnvironment *
gsh_new_GDLEnvironment()
{
	struct GDLEnvironment * env;

	env = xmalloc(sizeof(struct GDLEnvironment));
	SETUP_GDLENVIRONMENT(env);

	return env;
}

