/*
  AntiRight
  (c) 2007 Jeffrey Bedard
  antiright@gmail.com

  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

/* Set the dictionary to use for this definition file.  */
#define DICT gsh_guidl_env->dictionaries->dialog
#include "gtkshell.h"

extern struct GDLEnvironment * gsh_guidl_env;

#define DEF(a, b) GSH_GUIDL_DEFINE(DICT, a, b)

static void
setup_dictionary()
{
	DICT=ARNEW(ar, ARTupleVector);
	/* Begin adding mappings between keys and values.  */
	DEF("file", "-df");
	DEF("font", "-dF");
	DEF("about", "-da");
	DEF("folder", "-dd");
	DEF( "create folder", "-dD");
	DEF("save", "-ds");
	DEF("color", "-dc");
	DEF("info", "-di");
	DEF("warning", "-dw");
	DEF("error", "-de");
}

/* Generate public function to access these definitions.  */
GSH_GUIDL_ITEM_FUNC(dialog, DICT);

