/*
  AntiRight
  (c) 2002-2007 Jeffrey Bedard
  antiright@gmail.com

  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor,
  Boston, MA  02110-1301  USA
*/

#include "gtkshell.h"

static void
delete_child_classes(GSH * gsh)
{
	ARDELETE(gsh->rows);
	ARDELETE(gsh->terminal);
	ARDELETE(gsh->update);
}

static void
gsh_delete_GSH(struct GSH * gsh)
{
	delete_child_classes(gsh);
	GSH_FREE_IF(gsh->geometry);
}

static void
setup_add_methods(GSH * gsh)
{
#define GSHA gsh->add
	GSHA.window=&gsh_GSH_add_window;
	GSHA.button=&gsh_add_button;
	GSHA.label=&gsh_add_label;
}

static void
setup_methods(GSH * gsh)
{
	gsh->delete = &gsh_delete_GSH;
	gsh->parse = &gsh_parse_arguments;
	gsh->finalize = &gsh_GSH_finalize;
	gsh->init = &gsh_setup_containers;
	gsh->manage=&gsh_manage;
	setup_add_methods(gsh);
}

static void
setup_child_classes(GSH * gsh)
{
	gsh->update = ARNEW(gsh, GSHUpdateManager);
	gsh->rows = ARNEW(gsh, GSHRows);
	gsh->terminal = ARNEW(gsh, GSH_Terminal, gsh);
}

#define GWA gsh->widgets.app

static void
setup_app_menus(GSH * gsh)
{
#define GWAM GWA.menus
	GWAM.file=NULL;
	GWAM.edit=NULL;
	GWAM.view=NULL;
	GWAM.tools=NULL;
	GWAM.help=NULL;
}

static void
setup_widget_app_member_fields(GSH * gsh)
{
	GWA.menubar=NULL;
	setup_app_menus(gsh);
	GWA.frame=NULL;
	GWA.status=NULL;
}

static void
setup_widget_member_fields(GSH * gsh)
{
	gsh->widgets.last_managed=NULL;
	setup_widget_app_member_fields(gsh);
}

static void
setup_editor_member_fields(GSH * gsh)
{
	gsh->editor.widget=NULL;
	gsh->editor.filename=NULL;
}

static void
setup_main_member_fields(GSH * gsh)
{
	gsh->geometry = (gchar *)NULL;
	gsh->bflags = 0;
	gsh->icon_size=GTK_ICON_SIZE_DND;
}

static void
setup_member_fields(GSH * gsh)
{
	setup_widget_member_fields(gsh);
	setup_editor_member_fields(gsh);
	setup_main_member_fields(gsh);
}

static void
setup_gsh(GSH * gsh)
{
	setup_child_classes(gsh);
	setup_methods(gsh);
	setup_member_fields(gsh);
	/* Add initial window.  */
	$(gsh, add.window);
}

struct GSH *
gsh_new_GSH()
{
	struct GSH *gsh;

	gsh = (struct GSH *) xmalloc(sizeof(struct GSH));
	setup_gsh(gsh);
	
	return gsh;
}

