/*
  AntiRight
  (c) 2002-2006 Jeffrey Bedard
  antiright@gmail.com

  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef GSH_FILE_DIALOG
#define GSH_FILE_DIALOG

void
gsh_file_dialog(struct GSH * gsh, 
		GtkFileChooserAction action) __attribute__((noreturn));

#define GSH_FILE_OPEN_DIALOG(gsh)\
	gsh_file_dialog(gsh, GTK_FILE_CHOOSER_ACTION_OPEN)

#define GSH_FILE_SAVE_DIALOG(gsh)\
	gsh_file_dialog(gsh, GTK_FILE_CHOOSER_ACTION_SAVE)

#define GSH_FOLDER_CREATE_DIALOG(gsh)\
	gsh_file_dialog(gsh, GTK_FILE_CHOOSER_ACTION_CREATE_FOLDER)

#define GSH_FOLDER_OPEN_DIALOG(gsh)\
	gsh_file_dialog(gsh, GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER);

#endif /* !GSH_FILE_DIALOG */
