/*
  AntiRight
  (c) 2007 Jeffrey Bedard
  antiright@gmail.com

  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "gtkshell.h"
#include <time.h>

static gchar *
get_time_string()
{
	gchar * time_string;
	struct tm split_time;
	time_t time_value;

	(void)time(&time_value);
	(void)localtime_r(&time_value, &split_time);
	asprintf(&time_string, "%.2d/%.2d/%.2d\n%.2d:%.2d:%.2d",
		split_time.tm_mon+1,
		split_time.tm_mday,
		split_time.tm_year%100,
		split_time.tm_hour,
		split_time.tm_min,
		split_time.tm_sec);

	return time_string;
}

static void
update_clock(const gchar * command, gpointer clock_pointer)
{
	GtkWidget * clock;
	gchar * time_string;

	UNUSED(command);
	clock=(GtkWidget *)clock_pointer;
	time_string=get_time_string();
	gtk_label_set_text(GTK_LABEL(clock), time_string);
	g_free(time_string);
}

GtkWidget *
gsh_clock_new(GSH * gsh)
{
	GtkWidget * clock;
	struct GSHUpdatedWidget * updated_widget;
	
	clock=gtk_label_new(NULL);
	gsh_widget_set_font(clock, NULL);
	updated_widget=ARNEW(gsh, GSHUpdatedWidget, 
		&update_clock, NULL, clock);
	$(gsh->update, add, updated_widget); 

	return clock;
}

