/*
  AntiRight
  (c) 2007 Jeffrey Bedard
  antiright@gmail.com

  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "gtkshell.h"

static void
setup_about_license(GtkWidget * dialog)
{
	gchar * text;

	gtk_about_dialog_set_license(GTK_ABOUT_DIALOG(dialog),
		text=antiright_read_named_file(GSH_LICENSE_FILE));
	g_free(text);
}

static void
setup_authors_field(GtkWidget * dialog)
{
	const gchar *authors[] = GSH_AUTHORS;

	gtk_about_dialog_set_authors(GTK_ABOUT_DIALOG(dialog),
		authors);
}

#define SET_WEBSITE(dialog)\
	gtk_about_dialog_set_website(GTK_ABOUT_DIALOG(dialog), GSH_WEBSITE);

#define SET_COMMENTS(dialog)\
	gtk_about_dialog_set_comments(GTK_ABOUT_DIALOG(dialog), GSH_COMMENTS);	

#define SET_COPYRIGHT(dialog)\
	gtk_about_dialog_set_copyright(GTK_ABOUT_DIALOG(dialog),\
		GSH_COPYRIGHT);

#define SET_VERSION(dialog)\
	gtk_about_dialog_set_version(GTK_ABOUT_DIALOG(dialog), PACKAGE_STRING);

static void
setup_logo(GtkAboutDialog * dialog)
{
	GtkWidget * image;
	
#define ARICONDIR "/share/ACE-desktop/icons/"
	image=gtk_image_new_from_file(PREFIX ARICONDIR "ACE.png");
	gtk_widget_show(image);
	gtk_about_dialog_set_logo(dialog, 
		gtk_image_get_pixbuf(GTK_IMAGE(image)));
}

static GtkWidget *
setup_about_fields(GtkWidget * dialog)
{
	setup_authors_field(dialog);
	setup_about_license(dialog);
	setup_logo(GTK_ABOUT_DIALOG(dialog));
	SET_WEBSITE(dialog);
	SET_COMMENTS(dialog);
	SET_COPYRIGHT(dialog);
	SET_VERSION(dialog);

	return dialog;
}

void
gsh_about_dialog()
{
	gtk_dialog_run(GTK_DIALOG(setup_about_fields(gtk_about_dialog_new())));
	exit(0);
}


