/*
  AntiRight
  (c) 2002-2006 Jeffrey Bedard
  antiright@gmail.com

  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "gtkshell.h"

/* gsh->geometry is freed after this, so only call once.  */
void
gsh_set_geometry(struct GSH * gsh)
{
	ARIFP(gsh->geometry)
	{
		gtk_window_parse_geometry(GTK_WINDOW(gsh->window),
					  gsh->geometry);
		free(gsh->geometry);
	}
}

static gboolean
gsh_check_geometry(struct GSH * gsh)
{
	if (!ARPBOOL(gsh->geometry) 
	    && ((gsh->bflags & GSH_SCROLL) == GSH_SCROLL))
		ar_asprintf(&gsh->geometry, "400x267");

	ARIFP(gsh->geometry)
		return TRUE;
	else
		return FALSE;
}

void
gsh_check_and_set_geometry(struct GSH * gsh)
{
	if (gsh_check_geometry(gsh))
		gsh_set_geometry(gsh);
}
