/*
  AntiRight
  (c) 2007 Jeffrey Bedard
  antiright@gmail.com

  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "gshterm.h"
#include <sys/types.h>
#include <sys/stat.h>

/* Returned value must be freed.  */
char *
gshterm_command_script(char *command)
{
	gchar *script_name;
	FILE *script;
	gint fd;

#ifdef DEBUG
	ARBUG("gshterm_command_script()");
#endif				/* DEBUG */

	ARPASSERT(command);

	/* This is a workaround for vte's fscking up of option arrays.  */

	fd = g_file_open_tmp("gshterm.XXXXXX", &script_name, NULL);
	ARASSERT(fd != -1);

	/*
	 * Do this immediately after opening in order to reduce the
	 * possiblity of script modification exploit.
	 */
	if (fchmod(fd, S_IXUSR | S_IRUSR | S_IWUSR) != 0)
		ARERR("script file does not exist");
	
	ARIFNP((script=fdopen(fd, "w")))
		ARERR("script file could not be opened");

	//fflush(script);
	if(fsync(fd) == EOF)
		ARERR("cannot write script file");
	
	fprintf(script, "#!/bin/sh\n%s\n", command);
	g_free(command);
	fclose(script); /* Close and flush buffers.  */

#ifdef DEBUG
	sysprintf("cat %s", script_name);
	ARBUG("end gshterm_command_script()");
#endif				/* DEBUG */

	return (script_name);
}
