/*
  AntiRight
  (c) 2002-2006 Jeffrey Bedard
  antiright@gmail.com

  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef GSH_GTKSHELL_H
#define GSH_GTKSHELL_H

#include <gtk/gtk.h>
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include "../libantiright/library.h"

struct GSH_Rows
{
	GtkWidget *h;
	GtkWidget *v;
	unsigned int row;
	unsigned int rows;
};

struct GSH_Updater
{
	unsigned int period;
	/*@null@*/ GSList *list;
};

#define GSH_NONE		0
#define GSH_SCROLL 		1
#define GSH_CBEXIT 		2
#define GSH_UPDATING		4
#define GSH_HORIZONTAL_LABELS	8
#define GSH_PROMPT_ECHOES	16
#define GSH_FRAMED_LABELS	32
#define GSH_MENU_BUTTON		64

struct GSH
{
	/*@shared@*/ GtkWidget *window;
	/*@shared@*/ GtkWidget *scrolled_window;
	struct GSH_Rows rows;
	struct GSH_Updater update;
	/*@shared@*/GtkWidget *button;
	/*@null@*/ gchar *geometry;
	guint bflags;
};

#include "arguments.h"
#include "options.h"
#include "callbacks.h"
#include "updated.h"
#include "label.h"
#include "button.h"
#include "text.h"
#include "updated_label.h"
#include "updated_progress.h"
#include "option_options.h"
#include "updated_options.h"
#include "add_options.h"
#include "dialog_options.h"
#include "file_dialog.h"
#include "row.h"
#include "containers.h"
#include "geometry.h"
#include "font.h"
#include "dragdrop.h"
#include "image_button.h"

void
gsh_stack_init(struct GSH * gsh, int *argc, char ***argv);

struct GSH *
gsh_init(int *argc, char ***argv);

GtkWidget *
gsh_create_main_window();

void
gsh_GSH(struct GSH * gsh);

struct GSH *
gsh_new_GSH();

#endif /* !GSH_GTKSHELL_H */
