/*
  AntiRight
  (c) 2002-2006 Jeffrey Bedard
  antiright@gmail.com

  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "gtkshell.h"

static void
scrolled_window_options(struct GSH * gsh)
{
	gtk_scrolled_window_set_policy(
			GTK_SCROLLED_WINDOW(gsh->scrolled_window),
			GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

	gtk_scrolled_window_set_shadow_type(
			GTK_SCROLLED_WINDOW(gsh->scrolled_window),
			GTK_SHADOW_OUT);
}

void
gsh_setup_scrolled_window(struct GSH * gsh)
{
	gsh->scrolled_window = gtk_scrolled_window_new(NULL, NULL);
	scrolled_window_options(gsh);
	gtk_container_add(GTK_CONTAINER(gsh->window),
			  gsh->scrolled_window);
	gtk_widget_show(gsh->scrolled_window);

}

static void
setup_framed(struct GSH * gsh)
{
	GtkWidget *frame;

	frame = gtk_frame_new(NULL);
	gtk_container_add(GTK_CONTAINER(gsh->window),
			frame);
	gtk_widget_show(frame);
	gtk_container_add(GTK_CONTAINER(frame),
			gsh->rows.h);
}


void
gsh_setup_containers(struct GSH * gsh)
{
	gsh->rows.h = gtk_hbox_new(FALSE, 2);

	if ((gsh->bflags & GSH_SCROLL) == GSH_SCROLL)
	{
		gsh_setup_scrolled_window(gsh);
		gtk_scrolled_window_add_with_viewport(
			    GTK_SCROLLED_WINDOW(gsh->scrolled_window),
					        gsh->rows.h);
	}
	else
		setup_framed(gsh);

	gtk_widget_show(gsh->rows.h);
	gsh_new_row(gsh);
}
