/*
  AntiRight
  (c) 2002-2006 Jeffrey Bedard
  antiright@gmail.com

  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "gtkshell.h"

static void
gsh_test_exit(struct GSH * gsh)
{

#ifdef DEBUG
	ARBUG("gsh_test_exit()");
#endif				/* DEBUG */

	if (ARPBOOL(gsh) && ((gsh->bflags & GSH_CBEXIT) == GSH_CBEXIT))
		exit(EXIT_SUCCESS);

#ifdef DEBUG
	ARBUG("==>made it past exit");
#endif				/* DEBUG */
}

void
system_cb(GtkWidget *widget, gpointer data)
{
	struct GSH_CBData *cb;

	cb = (struct GSH_CBData *) data;

#ifdef DEBUG
	ARBUG("system_cb");
#endif				/* DEBUG */

	UNUSED(widget);

	ARWIFNP(cb)
	{
		(void) antiright_system(cb->data);
		gsh_test_exit(cb->gsh);
	}
}

void
entry_cb(GtkWidget *widget, gpointer data)
{
	const gchar *input;	/* Must not be freed.  */
	struct GSH_CBData *cb;

	cb = (struct GSH_CBData *) data;

	ARWIFNP(widget)
	{
		input = gtk_entry_get_text(GTK_ENTRY(widget));

		ARWIFNP(cb)
		{
			if((cb->gsh->bflags & GSH_PROMPT_ECHOES)
			    == GSH_PROMPT_ECHOES)
				g_print("%s\n", input);
			else
				sysprintf("%s %s", (char *) cb->data, 
					(char *) input);

			gsh_test_exit(cb->gsh);
		}

		gtk_entry_set_text(GTK_ENTRY(widget), "");	/* Clear.  */
	}
}
