/*
  AntiRight
  (c) 2002-2007 Jeffrey Bedard
  antiright@gmail.com

  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, 
  	Boston, MA  02110-1301  USA
*/

#include "gtkshell.h"

static void
setup_label(GtkWidget *widget, char *command);

static void
create_label_in_menu_item(GtkWidget * widget, char * formatted)
{
	/*@shared@*/GtkWidget * label;

	label = gtk_label_new(formatted);
	gtk_container_add(GTK_CONTAINER(widget), label);
	gtk_widget_show(label);
}

static void
setup_label(GtkWidget *widget, char *command)
{
	/*@only*/gchar *formatted;

	formatted = antiright_beautified_label(command);

	if(GTK_IS_MENU_ITEM(widget))
		create_label_in_menu_item(widget, formatted);
	else
		gtk_button_set_label(GTK_BUTTON(widget), formatted);

	g_free(formatted);
}

static struct GSH_CBData *
setup_callback_data(struct GSH * gsh, char * command)
{
	struct GSH_CBData * cb;

	/* Allocate and initialize elements.  */
	cb = (struct GSH_CBData *) 
		xmalloc(sizeof(struct GSH_CBData));

	cb->gsh = gsh;
	cb->data = command;	/* command from argv, literal, or
				 * preallocated
				 * */

	return cb;
}

static void
setup_callback(struct GSH * gsh, char * command)
{
	struct GSH_CBData * cb;

	cb=setup_callback_data(gsh, command);

	ARIFB(GTK_IS_MENU_ITEM(gsh->button))
	{
		(void) g_signal_connect(G_OBJECT(gsh->button), 
				"activate", G_CALLBACK(system_cb), cb);

	}
	else if((gsh->bflags & GSH_MENU_BUTTON) != GSH_MENU_BUTTON)
	{
		(void) g_signal_connect(G_OBJECT(gsh->button), 
				"clicked", G_CALLBACK(system_cb), cb);
	}
	/* If the button launches a menu, do not add a system_cb.  */
	else if((gsh->bflags & GSH_MENU_BUTTON) == GSH_MENU_BUTTON)
		gsh->bflags ^= GSH_MENU_BUTTON;

}

static void
create_button(struct GSH * gsh)
{
	if(!GTK_IS_MENU(gsh->rows.v))
	{
		gsh->button = gtk_button_new();
		/* For now, we only do drag 
		 * and drop with regular buttons.  */
		gsh_setup_drag_drop(gsh, gsh->button);
	}
	else
		gsh->button = gtk_menu_item_new();

	gtk_widget_show(gsh->button);
}

void
gsh_command_button(struct GSH * gsh, char *command)
{
#ifdef DEBUG
	ARBUG("gsh_command_button");
#endif				/* DEBUG */

	ARPASSERT(gsh);

	create_button(gsh);
	setup_label(gsh->button, command);
	setup_callback(gsh, command);
	gsh_manage_unexpanded(gsh, gsh->button);

#ifdef DEBUG
	g_debug("==> row: %d out of %d rows\n",
		gsh->rows.row, gsh->rows.rows);
#endif				/* DEBUG */
}


