/*
  AntiRight
  (c) 2002-2006 Jeffrey Bedard
  antiright@gmail.com

  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "gtkshell.h"

void
gsh_update_progress(char *command, void *widget)
{
	char *results;
	results=antiright_pipe_read(command);
	gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR((GtkWidget*) widget),
		strtod(results, NULL));
	free(results);
}
void
gsh_add_updated_progress(struct GSH *gsh, char *command)
{
	GtkWidget *widget;
	widget=gtk_progress_bar_new();
	gsh_manage(gsh, widget);
	gsh_add_updater(&gsh_update_progress, command, (void*)widget);
}

