/*
  AntiRight
  (c) 2002-2006 Jeffrey Bedard
  antiright@gmail.com

  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "gtkshell.h"

GtkWidget*
gsh_setup_command_entry(struct GSH *gsh, char *command)
{
 GtkWidget      *entry;
	struct GSH_CBData *cb;

	cb=(struct GSH_CBData *)xmalloc(sizeof(struct GSH_CBData));
	cb->gsh=gsh;
	asprintf((char **)&cb->data, "%s", command);
 entry = gtk_entry_new();
 g_signal_connect(G_OBJECT(entry), "activate", G_CALLBACK(entry_cb),
		  (gpointer) cb);
 gsh_manage(gsh, entry);
 return(entry);
}

void
gsh_setup_prompt_command_entry(struct GSH *gsh, char *command)
{
	GtkWidget *entry;
	entry=gsh_setup_command_entry(gsh, command);
	g_signal_connect(G_OBJECT(entry), "activate", 
		G_CALLBACK(gtk_main_quit), NULL);
}

void
gsh_text_area(struct GSH *gsh)
{
	GtkWidget *text;
	
	text=gtk_text_view_new();
	gsh_manage(gsh, text);
}

