/*
  AntiRight
  (c) 2007 Jeffrey Bedard
  antiright@gmail.com

  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "gshterm.h"
#include <unistd.h>


struct GSHTerm *
gshterm_init_and_script(int *argc, char ***argv)
{
	struct GSHTerm *term;

	term=(struct GSHTerm *)xmalloc(sizeof(struct GSHTerm));

	term->gsh=gsh_init(argc, argv);

#ifdef DEBUG
	assert(term->gsh);
	assert(term->gsh->window);
#endif /* DEBUG */	

	term->script=gshterm_command_script(
		gshterm_construct_command(term, *argc, *argv));


	return(term);
}

int
main(int argc, char **argv)
{
	struct GSHTerm *term;
	gpointer script;

	/* Initialize GTK, GSH, and GSHTerm.  */
	term=gshterm_init_and_script(&argc, &argv);
	term->widget=gshterm_setup_terminal(term);
	gsh_check_and_set_geometry(term->gsh);
	g_signal_connect(G_OBJECT(term->widget), "child-exited",
		G_CALLBACK(gtk_main_quit), NULL);

	/* Run the script in the terminal widget.  */
	vte_terminal_fork_command(
		VTE_TERMINAL(term->widget), term->script, NULL, NULL, NULL,
		TRUE, TRUE, TRUE);

	script=term->script;

	gtk_widget_show(term->gsh->window);

	g_free(term->gsh);
	g_free(term);

	gtk_main();

	unlink(script);
	g_free(script);

	return(0);
}

